/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.stonecraft.datastore.DbColumnName;
import com.stonecraft.datastore.DbTableGroup;
import com.stonecraft.datastore.DbTableName;
import com.stonecraft.datastore.ObjectInjector;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JoinObjectInjector
extends ObjectInjector {
    private Map<Class, List<Field>> mySubsetFields = new HashMap<Class, List<Field>>();
    private Map<Class, Map<String, InjectedValue>> myObjectsByClass = new HashMap<Class, Map<String, InjectedValue>>();
    private FieldMonitor myFieldMonitor = new FieldMonitor();
    private Map<InjectedValue, Boolean> myUniqueObjects = new HashMap<InjectedValue, Boolean>();

    public JoinObjectInjector(Query query) {
        super(query);
    }

    @Override
    public <T> T[] inject(RSData data, Class<T> classOfT) throws DatabaseException {
        ArrayList returnDataList = new ArrayList();
        data.moveToFirst();
        while (!data.isAfterLast()) {
            InjectedValue<T> injectedValue = this.getInjectedClass(data, classOfT);
            if (!this.myUniqueObjects.containsKey(injectedValue)) {
                this.myUniqueObjects.put(injectedValue, true);
                returnDataList.add(injectedValue.rowData);
            }
            data.next();
        }
        return returnDataList.toArray((Object[])Array.newInstance(classOfT, returnDataList.size()));
    }

    private <T> InjectedValue<T> getInjectedClass(RSData data, Class<T> classOfT) throws DatabaseException {
        return this.injectObject(data, classOfT, null, null);
    }

    private <T> InjectedValue<T> injectObject(RSData data, Class<T> classOfT, @Nullable String tableName, @Nullable String foreignKey) throws DatabaseException {
        try {
            Field[] fields = this.getFields(classOfT);
            InjectedValue<T> injectObject = this.injectSubset(data, classOfT);
            boolean subsetsInjected = true;
            if (injectObject == null) {
                subsetsInjected = false;
                injectObject = new InjectedValue();
                injectObject.rowData = classOfT.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            ArrayList<String> foreignKeyValues = new ArrayList<String>();
            for (Field field : fields) {
                Object fieldValue;
                if (this.myFieldMonitor.wasFieldInjectedPreviously(injectObject, field)) continue;
                Annotation annotation = this.getAnnotation(field);
                Object rowData = injectObject.rowData;
                if (!subsetsInjected && annotation instanceof DbTableGroup) {
                    DbTableGroup dbTableGroupAnnotation = (DbTableGroup)this.getAnnotation(field);
                    field.setAccessible(true);
                    Class listType = this.getTypeOfList(field);
                    InjectedValue<T> subsetObject = this.injectObject(data, listType, dbTableGroupAnnotation.table(), dbTableGroupAnnotation.groupBy());
                    if (subsetObject.groupKeyValue == null) continue;
                    foreignKeyValues.add(subsetObject.groupKeyValue);
                    ArrayList list = new ArrayList();
                    list.add(subsetObject.rowData);
                    field.set(injectObject.rowData, list);
                    List<Field> subsetFields = this.mySubsetFields.get(classOfT);
                    if (subsetFields == null) {
                        subsetFields = new ArrayList<Field>();
                        this.mySubsetFields.put(classOfT, subsetFields);
                    }
                    subsetFields.add(field);
                    continue;
                }
                if (annotation instanceof DbTableName) {
                    field.setAccessible(true);
                    InjectedValue<?> subsetObject = this.injectObject(data, field.getType(), ((DbTableName)annotation).value(), null);
                    field.set(injectObject.rowData, subsetObject.rowData);
                    continue;
                }
                if (!(annotation instanceof DbColumnName)) continue;
                DbColumnName injectAnnotation = (DbColumnName)annotation;
                String column = this.getColumnKey(tableName, injectAnnotation.value());
                this.injectValue(data, rowData, field, column);
                if (!TextUtils.isEmpty((CharSequence)foreignKey) && injectAnnotation.value().equals(foreignKey) && (fieldValue = field.get(injectObject.rowData)) != null) {
                    injectObject.groupKeyValue = fieldValue.toString();
                }
                this.myFieldMonitor.setFieldInjected(injectObject, field);
            }
            this.trackObjectByClass(classOfT, injectObject, foreignKeyValues);
            return injectObject;
        }
        catch (InstantiationException e) {
            throw new DatabaseException("Failed to create an instance of the class to be injected with the data for this query for class type \" + classOfT.getName()", e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException("Failed to create an instance of the class to be injected with the data for this query for class type \" + classOfT.getName()", e);
        }
        catch (InvocationTargetException e) {
            throw new DatabaseException("Failed to create an instance of the class to be injected with the data for this query for class type \" + classOfT.getName()", e);
        }
        catch (NoSuchMethodException e) {
            throw new DatabaseException("Failed to create an instance of the class to be injected with the data for this query for class type " + classOfT.getName(), e);
        }
    }

    private <T> void trackObjectByClass(Class<T> classOfT, InjectedValue<T> injectObject, List<String> foreignKeyValues) {
        String mapForeignKey = this.getForeignKey(foreignKeyValues);
        if (!TextUtils.isEmpty((CharSequence)mapForeignKey)) {
            Map<String, InjectedValue> objectsByClass = this.myObjectsByClass.get(classOfT);
            if (objectsByClass == null) {
                objectsByClass = new HashMap<String, InjectedValue>();
            }
            objectsByClass.put(mapForeignKey, injectObject);
            this.myObjectsByClass.put(classOfT, objectsByClass);
        }
    }

    private <T> InjectedValue<T> injectSubset(RSData data, Class<T> rootClass) throws DatabaseException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ArrayList<String> foreignKeyValues = new ArrayList<String>();
        HashMap<Field, InjectedValue<T>> subsets = new HashMap<Field, InjectedValue<T>>();
        List<Field> subsetFields = this.mySubsetFields.get(rootClass);
        if (subsetFields == null) {
            return null;
        }
        for (Field field : subsetFields) {
            DbTableGroup dbTableGroupAnnotation = (DbTableGroup)this.getAnnotation(field);
            Class innerClassType = this.getTypeOfList(field);
            InjectedValue<T> subsetObject = this.injectObject(data, innerClassType, dbTableGroupAnnotation.table(), dbTableGroupAnnotation.groupBy());
            if (subsetObject.groupKeyValue == null) continue;
            foreignKeyValues.add(subsetObject.groupKeyValue);
            subsets.put(field, subsetObject);
        }
        String foreignKey = this.getForeignKey(foreignKeyValues);
        InjectedValue rootClassObject = this.myObjectsByClass.get(rootClass).get(foreignKey);
        if (rootClassObject == null) {
            rootClassObject = new InjectedValue();
            rootClassObject.rowData = rootClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.trackObjectByClass(rootClass, rootClassObject, foreignKeyValues);
        }
        for (Field field : subsetFields) {
            ArrayList list = null;
            try {
                list = (ArrayList)field.get(rootClassObject.rowData);
                if (list == null) {
                    list = new ArrayList();
                    field.set(rootClassObject.rowData, list);
                }
            }
            catch (IllegalAccessException e) {
                throw new DatabaseException("Could not access the field " + field.getName() + " in class " + rootClass.getName() + " while trying to inject data for a join query");
            }
            InjectedValue subset = (InjectedValue)subsets.get(field);
            if (subset == null) continue;
            list.add(subset.rowData);
        }
        return rootClassObject;
    }

    private String getForeignKey(List<String> foreignKeyValues) {
        if (foreignKeyValues == null) {
            String string = "";
        }
        Collections.sort(foreignKeyValues);
        StringBuilder keyBuilder = new StringBuilder();
        for (String foreignKeyValue : foreignKeyValues) {
            keyBuilder.append(foreignKeyValue);
        }
        return keyBuilder.toString();
    }

    private static class InjectedValue<T> {
        T rowData;
        String groupKeyValue;

        private InjectedValue() {
        }
    }

    private static class FieldMonitor
    extends HashMap<InjectedValue, Map<Field, Boolean>> {
        private FieldMonitor() {
        }

        public boolean wasFieldInjectedPreviously(InjectedValue object, Field field) {
            Map fieldsMap = (Map)this.get(object);
            if (fieldsMap == null || !fieldsMap.containsKey(field)) {
                return false;
            }
            return (Boolean)fieldsMap.get(field);
        }

        public void setFieldInjected(InjectedValue object, Field field) {
            if (this.containsKey(object)) {
                ((Map)this.get(object)).put(field, true);
                return;
            }
            HashMap<Field, Boolean> monitorMap = new HashMap<Field, Boolean>();
            monitorMap.put(field, true);
            this.put(object, monitorMap);
        }
    }
}

