/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.DbColumnName;
import com.stonecraft.datastore.ObjectInjector;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public final class QueryObjectInjector
extends ObjectInjector {
    public QueryObjectInjector(Query query) {
        super(query);
    }

    @Override
    public <T> T[] inject(RSData data, Class<T> classOfT) throws DatabaseException {
        Object[] returnClasses = (Object[])Array.newInstance(classOfT, data.getCount());
        data.moveToFirst();
        int count = 0;
        while (!data.isAfterLast()) {
            Object injectedRow = null;
            injectedRow = this.getInjectedClass(data, classOfT);
            if (injectedRow != null) {
                returnClasses[count] = injectedRow;
            }
            data.next();
            ++count;
        }
        return returnClasses;
    }

    private <T> T getInjectedClass(RSData data, Class<T> classOfT) throws DatabaseException {
        try {
            Field[] fields = this.getFields(classOfT);
            T rowClass = classOfT.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : fields) {
                DbColumnName annotation = (DbColumnName)this.myAnnotations.get(field);
                if (annotation == null) {
                    annotation = field.getAnnotation(DbColumnName.class);
                    this.myAnnotations.put(field, annotation);
                }
                if (annotation == null) continue;
                DbColumnName InjectAnnotation = annotation;
                String column = this.getColumnKey(null, InjectAnnotation.value());
                this.injectValue(data, rowClass, field, column);
            }
            return rowClass;
        }
        catch (Throwable e) {
            throw new DatabaseException("Failed to create an instance of the class to be injected with the data for this query", e);
        }
    }
}

