/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.interfaces;

import android.content.Context;
import android.net.Uri;
import com.stonecraft.datastore.DbSchemaModel;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.RowCountQuery;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Delete;
import com.stonecraft.datastore.interaction.Insert;
import com.stonecraft.datastore.interaction.Query;
import com.stonecraft.datastore.interaction.Update;
import com.stonecraft.datastore.interfaces.ISchemaCreator;
import com.stonecraft.datastore.view.DatabaseColumn;
import com.stonecraft.datastore.view.DatabaseTable;
import com.stonecraft.datastore.view.DatabaseViewFactory;
import java.util.Calendar;

public interface IDBConnector {
    public static final int CHANGE_NONE = 0;
    public static final int CHANGE_ALLOWED = 1;
    public static final int CHANGE_EXCEPTION = -1;

    public String getName();

    public Context getContext();

    public int getVersion();

    public void startTransaction() throws DatabaseException;

    public void commit() throws DatabaseException;

    public void rollBack() throws DatabaseException;

    public void close();

    public boolean isOpen() throws DatabaseException;

    public RSData query(Query var1) throws DatabaseException;

    public long queryNumEntries(RowCountQuery var1);

    public void insert(Insert var1) throws DatabaseException;

    public int update(Update var1) throws DatabaseException;

    public int delete(Delete var1) throws DatabaseException;

    public void executeRawStatement(String var1) throws DatabaseException;

    public RSData executeRawQuery(String var1) throws DatabaseException;

    public int doesTableExist(String var1) throws DatabaseException;

    public void createConnection() throws DatabaseException;

    public void createSchema(ISchemaCreator var1) throws DatabaseException;

    public void updateTable(DatabaseTable var1, DatabaseTable var2) throws DatabaseException;

    public DatabaseViewFactory getTableObjectFactory();

    public int checkColumnUpdateRules(DatabaseColumn var1, DatabaseColumn var2) throws DatabaseException;

    public DbSchemaModel getDatabaseSchema();

    public Uri getTableUri(String var1);

    public Calendar getTableChangeDate(String var1);

    public void sendTableUpdateNotification(String var1);
}

