/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.DatabaseTask;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.JoinObjectInjector;
import com.stonecraft.datastore.ObjectInjector;
import com.stonecraft.datastore.OnQueryComplete;
import com.stonecraft.datastore.OnUnparsedQueryComplete;
import com.stonecraft.datastore.QueryComplete;
import com.stonecraft.datastore.QueryDeserializer;
import com.stonecraft.datastore.QueryObjectInjector;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;
import com.stonecraft.datastore.interaction.RawSQLQuery;
import com.stonecraft.datastore.interfaces.IDBConnector;

class DatabaseQueryTask
extends DatabaseTask {
    private Query myQuery;
    private QueryComplete myQueryListener;
    private Class myInjectorClass;
    private Object myResult;
    private QueryDeserializer myQueryDeserializer;

    public DatabaseQueryTask(int taskId, int token, Datastore datastore, Query query) {
        super(taskId, token, datastore);
        this.myQuery = query;
    }

    public void setInjectorClass(Class injectorClass) {
        this.myInjectorClass = injectorClass;
    }

    @Override
    public void startTask() throws DatabaseException {
        if (this.myQuery instanceof Query) {
            this.myResult = this.startTask(this.myInjectorClass);
        }
    }

    public QueryDeserializer getQueryDeserializer() {
        return this.myQueryDeserializer;
    }

    public void setQueryDeserializer(QueryDeserializer queryDeserializer) {
        this.myQueryDeserializer = queryDeserializer;
    }

    public <T> T[] startTask(Class<T> classOfT) throws DatabaseException {
        RSData data = null;
        try {
            IDBConnector connector = this.myDatastore.getActiveDatabase();
            if (this.myQuery instanceof RawSQLQuery) {
                data = connector.executeRawQuery(((RawSQLQuery)this.myQuery).getQuery());
                Object[] objectArray = (Object[])this.parseQuery((RawSQLQuery)this.myQuery, data, classOfT);
                return objectArray;
            }
            if (this.myQuery instanceof Query) {
                data = connector.query(this.myQuery);
                Object[] objectArray = (Object[])this.parseQuery(this.myQuery, data, classOfT);
                return objectArray;
            }
            try {
                throw new DatabaseException("Unknown statement type " + this.myQuery.getClass().getSimpleName() + ". Must be either " + Query.class.getSimpleName() + " or " + RawSQLQuery.class.getSimpleName());
            }
            catch (DatabaseException e) {
                if (data != null) {
                    data.close();
                }
                if (this.myQueryListener != null) {
                    this.myQueryListener.onQueryFailed(this.myToken, e);
                }
                throw e;
            }
        }
        finally {
            this.notifyTaskListeners();
        }
    }

    @Override
    void notifyStmtListeners(DatabaseException e) {
        if (this.myQueryListener != null) {
            if (e != null) {
                this.myQueryListener.onQueryFailed(this.myToken, e);
            } else if (this.myQueryListener instanceof OnUnparsedQueryComplete) {
                ((OnUnparsedQueryComplete)this.myQueryListener).onQueryComplete(this.myToken, (RSData)this.myResult);
            } else {
                ((OnQueryComplete)this.myQueryListener).onQueryComplete(this.myToken, (Object[])this.myResult);
            }
        }
    }

    private Object parseQuery(Query query, RSData data, Class classOfT) throws DatabaseException {
        T[] result = null;
        if (this.myQueryListener != null) {
            result = ((OnQueryComplete)this.myQueryListener).parseData(data);
        }
        if (result == null) {
            if (this.myQueryDeserializer != null) {
                result = this.myQueryDeserializer.parseData(data);
            } else {
                ObjectInjector oi = query.getJoins().isEmpty() ? new QueryObjectInjector(query) : new JoinObjectInjector(query);
                result = oi.inject(data, classOfT);
            }
        }
        data.close();
        return result;
    }

    public void setOnQueryCompleteListener(OnQueryComplete listener) {
        this.myQueryListener = listener;
    }
}

