/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.net.Uri;
import com.stonecraft.datastore.DatabaseNonQueryTask;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Delete;
import com.stonecraft.datastore.interaction.Insert;
import com.stonecraft.datastore.interaction.RawStatement;
import com.stonecraft.datastore.interaction.Statement;
import com.stonecraft.datastore.interaction.Update;
import com.stonecraft.datastore.interaction.UpdateTableStatement;
import com.stonecraft.datastore.interfaces.IDBConnector;
import com.stonecraft.datastore.interfaces.OnNonQueryComplete;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DatastoreTransaction {
    public static final int DEFAULT_TOKEN = -1;
    private List<Statement> myStatementList = new ArrayList<Statement>();
    private IDBConnector myConnection;

    public void addStatement(Statement statement) {
        this.myStatementList.add(statement);
    }

    public int getStatementCount() {
        return this.myStatementList.size();
    }

    public void execute(Datastore ds, OnNonQueryComplete listener) {
        this.myConnection = ds.getActiveDatabase();
        int taskId = new AtomicInteger().incrementAndGet();
        DatabaseNonQueryTask task = new DatabaseNonQueryTask(taskId, -1, ds, this);
        task.addOnStmtCompleteListener(listener);
        task.execute(new Void[0]);
    }

    public int executeOnCurrentThread(Datastore ds) throws DatabaseException {
        this.myConnection = ds.getActiveDatabase();
        return this.run();
    }

    void setConnection(IDBConnector connection) {
        this.myConnection = connection;
    }

    int run() throws DatabaseException {
        try {
            HashMap<Uri, Uri> updatedTableUris = new HashMap<Uri, Uri>();
            int result = 0;
            this.myConnection.startTransaction();
            for (Statement stmt : this.myStatementList) {
                Uri tableUri = this.myConnection.getTableUri(stmt.getTable());
                if (tableUri != null) {
                    updatedTableUris.put(tableUri, tableUri);
                }
                if (stmt instanceof Insert) {
                    this.myConnection.insert((Insert)stmt);
                    ++result;
                    continue;
                }
                if (stmt instanceof Update) {
                    result += this.myConnection.update((Update)stmt);
                    continue;
                }
                if (stmt instanceof Delete) {
                    result += this.myConnection.delete((Delete)stmt);
                    continue;
                }
                if (stmt instanceof RawStatement) {
                    this.myConnection.executeRawStatement(((RawStatement)stmt).getRawStatement());
                    continue;
                }
                if (stmt instanceof UpdateTableStatement) {
                    UpdateTableStatement updateTableStatement = (UpdateTableStatement)stmt;
                    this.myConnection.updateTable(updateTableStatement.getOldTable(), updateTableStatement.getNewTable());
                    continue;
                }
                result += this.myConnection.doesTableExist(stmt.getTable());
            }
            this.myConnection.commit();
            for (Uri uri : updatedTableUris.keySet()) {
                this.myConnection.getContext().getContentResolver().notifyChange(uri, null, false);
            }
            return result;
        }
        catch (DatabaseException e) {
            this.myConnection.rollBack();
            throw new DatabaseException("Failed to execute the transaction", e);
        }
    }
}

