/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.DatabaseTask;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.DatastoreTransaction;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interfaces.OnNonQueryComplete;
import java.util.ArrayList;
import java.util.List;

class DatabaseNonQueryTask
extends DatabaseTask {
    private DatastoreTransaction myTransaction;
    private List<OnNonQueryComplete> myStmtListeners;
    private int myResult;

    public DatabaseNonQueryTask(int taskId, int token, Datastore datastore, DatastoreTransaction transaction) {
        super(taskId, token, datastore);
        this.myTransaction = transaction;
        this.myStmtListeners = new ArrayList<OnNonQueryComplete>();
        this.myResult = -1;
    }

    @Override
    public void startTask() throws DatabaseException {
        if (!this.myDatastore.validateDBConnection()) {
            throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
        }
        this.myResult = this.myTransaction.run();
    }

    public void addOnStmtCompleteListener(OnNonQueryComplete listener) {
        if (listener != null) {
            this.myStmtListeners.add(listener);
        }
    }

    public int getTaskResult() {
        return this.myResult;
    }

    @Override
    void notifyStmtListeners(DatabaseException e) {
        for (OnNonQueryComplete listener : this.myStmtListeners) {
            if (e != null) {
                listener.onNonQueryFailed(this.myToken, e);
                continue;
            }
            listener.onNonQueryComplete(this.myToken, this.myResult);
        }
    }
}

