/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.AggregateQuery;
import com.stonecraft.datastore.DatabaseTask;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.OnAggregateQueryComplete;
import com.stonecraft.datastore.RowCountQuery;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interfaces.IDBConnector;

public class AggregateQueryTask
extends DatabaseTask {
    private AggregateQuery myQuery;
    private OnAggregateQueryComplete myQueryListener;
    private Object myResult;

    public AggregateQueryTask(int taskId, int token, Datastore datastore, AggregateQuery query) {
        super(taskId, token, datastore);
        this.myQuery = query;
    }

    @Override
    public void startTask() throws DatabaseException {
        this.myResult = this.run();
    }

    public Object run() throws DatabaseException {
        IDBConnector connector = this.myDatastore.getActiveDatabase();
        if (this.myQuery instanceof RowCountQuery) {
            return connector.queryNumEntries((RowCountQuery)this.myQuery);
        }
        throw new DatabaseException("Unknown statement type " + this.myQuery.getClass().getSimpleName());
    }

    public void setOnQueryCompleteListener(OnAggregateQueryComplete listener) {
        this.myQueryListener = listener;
    }

    @Override
    void notifyStmtListeners(DatabaseException e) {
        if (this.myQueryListener != null) {
            if (e != null) {
                this.myQueryListener.onQueryFailed(this.myToken, e);
            } else {
                this.myQueryListener.onQueryComplete(this.myToken, this.myResult);
            }
        }
    }
}

