/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.DatabaseObjectInjector;
import com.stonecraft.datastore.DatabaseTask;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;
import com.stonecraft.datastore.interaction.RawSQLQuery;
import com.stonecraft.datastore.interfaces.IDBConnector;
import com.stonecraft.datastore.interfaces.OnQueryComplete;

class DatabaseQueryTask
extends DatabaseTask {
    private Query myQuery;
    private OnQueryComplete myQueryListener;
    private Class myInjectorClass;
    private Object[] myResult;

    public DatabaseQueryTask(int taskId, int token, Datastore datastore, Query query) {
        super(taskId, token, datastore);
        this.myQuery = query;
    }

    public void setInjectorClass(Class injectorClass) {
        this.myInjectorClass = injectorClass;
    }

    @Override
    public void startTask() throws DatabaseException {
        this.myResult = this.startTask(this.myInjectorClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] startTask(Class<T> classOfT) throws DatabaseException {
        RSData data = null;
        try {
            IDBConnector connector = this.myDatastore.getActiveDatabase();
            if (this.myQuery instanceof Query) {
                data = connector.query(this.myQuery);
                Object[] objectArray = (Object[])this.parseQuery(data, classOfT);
                return objectArray;
            }
            if (this.myQuery instanceof RawSQLQuery) {
                data = connector.executeRawQuery(((RawSQLQuery)this.myQuery).getQuery());
                Object[] objectArray = (Object[])this.parseQuery(data, classOfT);
                return objectArray;
            }
            try {
                throw new DatabaseException("Unknown statement type " + this.myQuery.getClass().getSimpleName() + ". Must be either " + Query.class.getSimpleName() + " or " + RawSQLQuery.class.getSimpleName());
            }
            catch (DatabaseException e) {
                if (data != null) {
                    data.close();
                }
                this.myQueryListener.onQueryFailed(this.myToken, e);
            }
        }
        finally {
            this.notifyTaskListeners();
        }
        return null;
    }

    @Override
    void notifyStmtListeners(DatabaseException e) {
        if (this.myQueryListener != null) {
            if (e != null) {
                this.myQueryListener.onQueryFailed(this.myToken, e);
            } else {
                this.myQueryListener.onQueryComplete(this.myToken, this.myResult);
            }
        }
    }

    private Object parseQuery(RSData data, Class classOfT) throws DatabaseException {
        if (classOfT.getName().equals(RSData.class.getName())) {
            return new RSData[]{data};
        }
        T[] result = null;
        if (this.myQueryListener != null) {
            result = this.myQueryListener.parseData(data);
        }
        if (result == null) {
            return new DatabaseObjectInjector(this.myQuery).inject(data, classOfT);
        }
        data.close();
        return result;
    }

    public void setOnQueryCompleteListener(OnQueryComplete listener) {
        this.myQueryListener = listener;
    }
}

