/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.parser;

import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.stonecraft.datastore.DatabaseUtils;
import com.stonecraft.datastore.DbSchemaModel;
import com.stonecraft.datastore.exceptions.SchemaParseException;
import com.stonecraft.datastore.utils.StringUtils;
import com.stonecraft.datastore.view.DatabaseColumn;
import com.stonecraft.datastore.view.DatabaseTable;
import com.stonecraft.datastore.view.SQLiteColumn;
import com.stonecraft.datastore.view.SQLiteTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatabaseParser
extends AsyncTask<InputStream, Void, DbSchemaModel> {
    private static final String SCHEMA = "Schema";
    private static final String NAME = "Name";
    private static final String VERSION = "Version";
    private static final String TABLE = "Table";
    private static final String COLUMN = "Column";
    private static final String TYPE = "Type";
    private static final String PRIMARY = "Primary";
    private static final String AUTOINCREMENT = "AutoIncrement";
    private static final String NULLABLE = "Nullable";
    private static final String LENGTH = "length";
    private static final String URI = "uri";
    private static final String DEFAULT = "Default";
    private DbSchemaModel mySchema;
    private OnSchemaModelCreated myOnSchemaModelCreated;
    private DefaultHandler myHandler = new DefaultHandler(){
        private String myCurrentElement;
        private String myCurrentBlock;
        private Map<String, String> myTableValues;
        private Map<String, String> myColumnValues;
        private List<DatabaseColumn> myCols = new ArrayList<DatabaseColumn>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.myCurrentElement = qName;
            if (this.myCurrentElement.equals(DatabaseParser.SCHEMA)) {
                this.myCurrentBlock = qName;
            } else if (this.myCurrentElement.equals(DatabaseParser.TABLE)) {
                this.myCurrentBlock = qName;
            } else if (this.myCurrentElement.equals(DatabaseParser.COLUMN)) {
                this.myCurrentBlock = qName;
            }
            if (this.myCurrentBlock.equals(DatabaseParser.TABLE)) {
                if (this.myTableValues == null || this.myCols == null) {
                    this.myTableValues = new HashMap<String, String>();
                    this.myCols = new ArrayList<DatabaseColumn>();
                }
                if (DatabaseParser.TABLE.equals(qName)) {
                    this.myTableValues.put(DatabaseParser.URI, attributes.getValue(DatabaseParser.URI));
                }
            } else if (this.myCurrentBlock.equals(DatabaseParser.COLUMN)) {
                if (this.myColumnValues == null) {
                    this.myColumnValues = new HashMap<String, String>();
                }
                if (this.myCurrentElement.equals(DatabaseParser.TYPE)) {
                    this.myColumnValues.put(DatabaseParser.LENGTH, attributes.getValue(DatabaseParser.LENGTH));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.myCurrentElement = "";
            if (qName.equals(DatabaseParser.TABLE)) {
                if (TextUtils.isEmpty((CharSequence)this.myTableValues.get(DatabaseParser.URI))) {
                    throw new SchemaParseException("There was no uri attribute in the table element " + this.myTableValues.get(DatabaseParser.NAME));
                }
                DatabaseParser.this.mySchema.addTable(this.buildTable());
                this.myTableValues = new HashMap<String, String>();
                this.myCols = new ArrayList<DatabaseColumn>();
            } else if (qName.equals(DatabaseParser.COLUMN)) {
                this.myCols.add(this.buildCol());
                this.myColumnValues = new HashMap<String, String>();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String value = new String(ch).substring(start, start + length);
            if (!TextUtils.isEmpty((CharSequence)this.myCurrentElement)) {
                if (this.myCurrentBlock.equals(DatabaseParser.SCHEMA)) {
                    if (this.myCurrentElement.equals(DatabaseParser.NAME)) {
                        DatabaseParser.this.mySchema.setName(value);
                    } else if (this.myCurrentElement.equals(DatabaseParser.VERSION)) {
                        DatabaseParser.this.mySchema.setVersion(Integer.parseInt(value));
                    }
                } else if (this.myCurrentBlock.equals(DatabaseParser.TABLE) && !this.myCurrentBlock.equals(this.myCurrentElement)) {
                    this.myTableValues.put(this.myCurrentElement, value);
                } else if (this.myCurrentBlock.equals(DatabaseParser.COLUMN) && !this.myCurrentBlock.equals(this.myCurrentElement) && !TextUtils.isEmpty((CharSequence)this.myCurrentElement)) {
                    this.myColumnValues.put(this.myCurrentElement, value);
                }
            }
        }

        private DatabaseTable buildTable() {
            try {
                String name = this.myTableValues.get(DatabaseParser.NAME);
                String uri = this.myTableValues.get(DatabaseParser.URI);
                SQLiteTable table = new SQLiteTable(name, Uri.parse((String)uri));
                for (DatabaseColumn col : this.myCols) {
                    table.addColumn(col);
                }
                return table;
            }
            catch (Exception e) {
                System.out.println("Failed to create Table " + e);
                return null;
            }
        }

        private DatabaseColumn buildCol() {
            SQLiteColumn dbColumn = null;
            try {
                String name = this.myColumnValues.get(DatabaseParser.NAME);
                int type = DatabaseUtils.getIntDatatype(StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.TYPE)));
                int length = Integer.parseInt(StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.LENGTH)));
                boolean primary = StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.PRIMARY)).equalsIgnoreCase(Boolean.TRUE.toString());
                boolean autoIncrement = StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.AUTOINCREMENT)).equalsIgnoreCase(Boolean.TRUE.toString());
                boolean nullable = StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.NULLABLE)).equalsIgnoreCase(Boolean.TRUE.toString());
                String defaultValue = this.myColumnValues.get(DatabaseParser.DEFAULT);
                dbColumn = new SQLiteColumn(name, type, length, primary, nullable, autoIncrement);
                if (!TextUtils.isEmpty((CharSequence)defaultValue)) {
                    dbColumn.setDefaultValue(defaultValue);
                }
            }
            catch (Throwable e) {
                System.out.println("Failed to create Column " + e);
                e.printStackTrace();
            }
            return dbColumn;
        }
    };

    public DatabaseParser(OnSchemaModelCreated listener) {
        this.mySchema = new DbSchemaModel();
        this.myOnSchemaModelCreated = listener;
    }

    protected DbSchemaModel doInBackground(InputStream ... params) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(params[0], this.myHandler);
        }
        catch (MalformedURLException e) {
            System.out.println("MalformedURLException " + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IOException " + e);
            e.printStackTrace();
        }
        catch (SAXException e) {
            System.out.println("SAXException " + e);
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfigurationException " + e);
            e.printStackTrace();
        }
        return this.mySchema;
    }

    protected void onPostExecute(DbSchemaModel dbSchemaModel) {
        this.myOnSchemaModelCreated.OnSchemaModelCreated(dbSchemaModel);
    }

    public DbSchemaModel parse(String databaseLocation) {
        try {
            FileInputStream is = new FileInputStream(new File(databaseLocation));
            this.execute(new InputStream[]{is});
        }
        catch (IOException e) {
            System.out.println("IOException " + e);
            e.printStackTrace();
        }
        return this.mySchema;
    }

    public static interface OnSchemaModelCreated {
        public void OnSchemaModelCreated(DbSchemaModel var1);
    }
}

