/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Delete;
import com.stonecraft.datastore.interaction.Insert;
import com.stonecraft.datastore.interaction.RawStatement;
import com.stonecraft.datastore.interaction.Statement;
import com.stonecraft.datastore.interaction.Update;
import com.stonecraft.datastore.interaction.UpdateTableStatement;
import com.stonecraft.datastore.interfaces.IDBConnector;
import java.util.ArrayList;
import java.util.List;

public class DatastoreTransaction {
    private List<Statement> myStatementList = new ArrayList<Statement>();
    private IDBConnector myConnection;

    public void addStatement(Statement statement) {
        this.myStatementList.add(statement);
    }

    public void setConnection(IDBConnector connection) {
        this.myConnection = connection;
    }

    public void execute() throws DatabaseException {
        try {
            this.myConnection.startTransaction();
            for (Statement stmt : this.myStatementList) {
                if (stmt instanceof Insert) {
                    this.myConnection.insert((Insert)stmt);
                    continue;
                }
                if (stmt instanceof Update) {
                    this.myConnection.update((Update)stmt);
                    continue;
                }
                if (stmt instanceof Delete) {
                    this.myConnection.delete((Delete)stmt);
                    continue;
                }
                if (stmt instanceof RawStatement) {
                    this.myConnection.executeRawStatement(((RawStatement)stmt).getRawStatement());
                    continue;
                }
                if (!(stmt instanceof UpdateTableStatement)) continue;
                UpdateTableStatement updateTableStatement = (UpdateTableStatement)stmt;
                this.myConnection.updateTable(updateTableStatement.getOldTable(), updateTableStatement.getNewTable());
            }
            this.myConnection.commit();
        }
        catch (DatabaseException e) {
            this.myConnection.rollBack();
            throw new DatabaseException("Failed to execute the transaction", e);
        }
    }
}

