/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.view;

import android.net.Uri;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.utils.StringUtils;
import com.stonecraft.datastore.view.DatabaseColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class DatabaseTable {
    public static final String CREATE_TABLE = "CREATE TABLE";
    protected static final String PREFIX_TEMP = "TEMP_";
    protected Uri myUri;
    protected String myName;
    protected Map<String, DatabaseColumn> myColumns;
    protected boolean myIsTempTable;

    public DatabaseTable(String name, Uri uri) {
        this.myName = name;
        this.myUri = uri;
        this.myColumns = new HashMap<String, DatabaseColumn>();
    }

    public String getName() {
        return this.myName;
    }

    public String getDBName() {
        StringBuilder builder = new StringBuilder();
        if (this.isTempTable()) {
            builder.append(PREFIX_TEMP);
        }
        builder.append(this.myName);
        return builder.toString();
    }

    public Uri getUri() {
        return this.myUri;
    }

    public Map<String, DatabaseColumn> getColumns() {
        return this.myColumns;
    }

    public void addColumn(DatabaseColumn col) {
        this.myColumns.put(col.getName(), col);
    }

    public boolean isTempTable() {
        return this.myIsTempTable;
    }

    public void setTempTable(boolean isTempTable) {
        this.myIsTempTable = isTempTable;
    }

    public String getColumnNameString() {
        ArrayList<String> columns = new ArrayList<String>();
        for (DatabaseColumn column : this.myColumns.values()) {
            columns.add(column.getName());
        }
        return StringUtils.convertListToDelimitedString(columns, ",");
    }

    public abstract String getCreateTableStmt() throws DatabaseException;

    public abstract boolean hasCompositeKey();
}

