/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.util.Log;
import com.stonecraft.datastore.CreateTableTask;
import com.stonecraft.datastore.DatabaseNonQueryTask;
import com.stonecraft.datastore.DatabaseQueryTask;
import com.stonecraft.datastore.DatabaseTask;
import com.stonecraft.datastore.DbSchemaModel;
import com.stonecraft.datastore.OnConnectionCreated;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.android.AndroidDBConnection;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Insert;
import com.stonecraft.datastore.interaction.Query;
import com.stonecraft.datastore.interaction.Statement;
import com.stonecraft.datastore.interaction.Update;
import com.stonecraft.datastore.interfaces.IDBConnector;
import com.stonecraft.datastore.interfaces.ISchemaCreator;
import com.stonecraft.datastore.interfaces.OnNonQueryComplete;
import com.stonecraft.datastore.interfaces.OnQueryComplete;
import com.stonecraft.datastore.interfaces.OnTaskCompleteListener;
import com.stonecraft.datastore.interfaces.Tasker;
import com.stonecraft.datastore.parser.DatabaseParser;
import com.stonecraft.datastore.view.DatabaseTable;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Datastore
implements OnTaskCompleteListener {
    public static final int DEFAULT_TOKEN = -1;
    public static final String DB_EXTENSION = ".sqlite";
    public static final int FAIL_TYPE_QUERY_FAILED = -1;
    private static volatile Map<String, IDBConnector> myDBConnections;
    private static volatile List<DatabaseTask> myQueuedTasks;
    private IDBConnector myActiveDatabase = null;
    private boolean myTasksQueued = true;
    private boolean myBlockingCall = false;
    private boolean myIsAttemptReconnect = true;

    private Datastore() {
        if (myDBConnections == null) {
            myDBConnections = new HashMap<String, IDBConnector>();
        }
        if (myQueuedTasks == null) {
            myQueuedTasks = new ArrayList<DatabaseTask>();
        }
    }

    private Datastore(IDBConnector connection) {
        this();
        this.myActiveDatabase = connection;
    }

    public static Datastore getDataStore(String connection) {
        if (myDBConnections != null && myDBConnections.containsKey(connection)) {
            return new Datastore(myDBConnections.get(connection));
        }
        return null;
    }

    public boolean isBlockingCall() {
        return this.myBlockingCall;
    }

    public Datastore setBlockingCall(boolean blockingCall) {
        this.myBlockingCall = blockingCall;
        return this;
    }

    public boolean isTasksQueued() {
        return this.myTasksQueued;
    }

    public Datastore setTasksQueued(boolean queuedTasks) {
        this.myTasksQueued = queuedTasks;
        return this;
    }

    public boolean isAttemptReconnect() {
        return this.myIsAttemptReconnect;
    }

    public void setAttemptReconnect(boolean isAttemptReconnect) {
        this.myIsAttemptReconnect = isAttemptReconnect;
    }

    public static void createConnection(final Context context, InputStream databaseXml, final @Nullable OnConnectionCreated listener) throws DatabaseException {
        new DatabaseParser(new DatabaseParser.OnSchemaModelCreated(){

            @Override
            public void OnSchemaModelCreated(DbSchemaModel schema) {
                AndroidDBConnection connector = new AndroidDBConnection(context, schema, listener);
                Datastore.setConnection(connector);
            }
        }).execute(new InputStream[]{databaseXml});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setConnection(IDBConnector connection) {
        new Datastore();
        Class<Datastore> clazz = Datastore.class;
        synchronized (Datastore.class) {
            if (myDBConnections.containsKey(connection.getName())) {
                myDBConnections.get(connection.getName()).close();
                myDBConnections.remove(connection.getName());
            }
            if (myDBConnections.containsKey(connection.getName())) return;
            Class<Datastore> clazz2 = Datastore.class;
            synchronized (Datastore.class) {
                if (myDBConnections.containsKey(connection.getName())) return;
                myDBConnections.put(connection.getName(), connection);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public void createSchema(ISchemaCreator schema) throws DatabaseException {
        this.myActiveDatabase.createSchema(schema);
    }

    public static void closeAll() throws DatabaseException {
        for (Map.Entry<String, IDBConnector> entry : myDBConnections.entrySet()) {
            IDBConnector conn = entry.getValue();
            if (!conn.isOpen()) continue;
            conn.close();
        }
    }

    public void close() throws DatabaseException {
        if (this.myActiveDatabase != null && this.myActiveDatabase.isOpen()) {
            this.myActiveDatabase.close();
        }
    }

    public void executeQuery(int token, Query stmt, OnQueryComplete listener) {
        Method[] methods = listener.getClass().getMethods();
        Class injectorClass = Object.class;
        for (Method method : methods) {
            Class<?>[] clazzes;
            if (!method.getName().equals("onQueryComplete")) continue;
            for (Class<?> clazz : clazzes = method.getParameterTypes()) {
                if (clazz.getComponentType() == null) continue;
                Class<?> testClass = clazz.getComponentType();
                if (clazz.getComponentType().getName().equals(Object.class.getName())) continue;
                Log.d((String)"TEST", (String)clazz.getComponentType().getName());
                injectorClass = clazz.getComponentType();
            }
        }
        try {
            if (!this.validateDBConnection()) {
                throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
            }
        }
        catch (DatabaseException e) {
            listener.onQueryFailed(token, e);
        }
        int taskId = new AtomicInteger().incrementAndGet();
        DatabaseQueryTask task = new DatabaseQueryTask(taskId, token, this.myActiveDatabase, stmt);
        task.setOnQueryCompleteListener(listener);
        task.setInjectorClass(injectorClass);
        try {
            this.executeStmt(task);
        }
        catch (DatabaseException e) {
            listener.onQueryFailed(token, e);
        }
    }

    public <T> T[] executeQuery(Query stmt, Class<T> classToInject) throws DatabaseException {
        if (!this.validateDBConnection()) {
            throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
        }
        int taskId = new AtomicInteger().incrementAndGet();
        DatabaseQueryTask task = new DatabaseQueryTask(taskId, -1, this.myActiveDatabase, stmt);
        return task.executeTask(classToInject);
    }

    public void executeNonQuery(int token, Statement stmt, OnNonQueryComplete listener) {
        try {
            if (!this.validateDBConnection()) {
                throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
            }
        }
        catch (DatabaseException e) {
            listener.onNonQueryFailed(token, e);
        }
        int taskId = new AtomicInteger().incrementAndGet();
        DatabaseNonQueryTask task = new DatabaseNonQueryTask(taskId, token, this.myActiveDatabase, stmt);
        task.addOnStmtCompleteListener(listener);
        try {
            this.executeStmt(task);
        }
        catch (DatabaseException e) {
            listener.onNonQueryComplete(token, -1);
        }
    }

    public int executeNonQuery(Statement stmt) throws DatabaseException {
        if (!this.validateDBConnection()) {
            throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
        }
        int taskId = new AtomicInteger().incrementAndGet();
        DatabaseNonQueryTask task = new DatabaseNonQueryTask(taskId, -1, this.myActiveDatabase, stmt);
        task.executeTask();
        return task.getTaskResult();
    }

    public void executeAddOrUpdate(int token, final String whereClause, final Insert insert, final OnNonQueryComplete listener) {
        Query query = new Query(insert.getTable());
        query.whereClause(whereClause);
        this.executeQuery(token, query, new OnQueryComplete<RSData>(){

            public void onQueryComplete(int token, RSData[] resultSets) {
                RSData resultSet = resultSets[0];
                resultSet.moveToFirst();
                Statement updateOrAddStmt = null;
                if (resultSet.getCount() <= 0) {
                    updateOrAddStmt = insert;
                } else {
                    Map<String, Object> values = insert.getValues();
                    if (!values.isEmpty()) {
                        Update update = new Update(insert.getTable(), values, whereClause, null);
                        updateOrAddStmt = update;
                    }
                }
                resultSet.close();
                if (updateOrAddStmt != null) {
                    Datastore.this.executeNonQuery(token, updateOrAddStmt, listener);
                } else {
                    listener.onNonQueryFailed(token, new DatabaseException("No values were in the insert object when a executeAddOrUpdate() was attempted"));
                }
            }

            @Override
            public void onQueryFailed(int token, DatabaseException e) {
                listener.onNonQueryFailed(token, e);
            }
        });
    }

    public boolean isConnectionAvail() {
        try {
            return this.myActiveDatabase.isOpen();
        }
        catch (DatabaseException e) {
            Log.e((String)Datastore.class.getSimpleName(), (String)("Failed to check if database is open [" + e + "] false will be returned from isConnectionAvail()"));
            return false;
        }
    }

    public void doesTableExist(int token, String tableName, OnNonQueryComplete listener) {
        try {
            if (!this.validateDBConnection()) {
                throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
            }
        }
        catch (DatabaseException e) {
            listener.onNonQueryFailed(token, e);
            return;
        }
        int taskId = new AtomicInteger().incrementAndGet();
        DatabaseNonQueryTask task = new DatabaseNonQueryTask(taskId, token, this.myActiveDatabase, new Statement(tableName));
        task.addOnStmtCompleteListener(listener);
        try {
            this.executeStmt(task);
        }
        catch (DatabaseException e) {
            listener.onNonQueryFailed(token, e);
        }
    }

    public void createTable(int token, DatabaseTable table, OnNonQueryComplete listener) {
        try {
            if (!this.validateDBConnection()) {
                throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
            }
        }
        catch (DatabaseException e) {
            listener.onNonQueryFailed(token, e);
        }
        int taskId = new AtomicInteger().incrementAndGet();
        CreateTableTask task = new CreateTableTask(taskId, token, this.myActiveDatabase, table);
        task.addOnStmtCompleteListener(listener);
        try {
            this.executeStmt(task);
        }
        catch (DatabaseException e) {
            listener.onNonQueryFailed(token, e);
        }
    }

    public Uri getTableUri(String tableName) {
        return this.myActiveDatabase.getTableUri(tableName);
    }

    private boolean validateDBConnection() throws DatabaseException {
        if (this.isConnectionAvail()) {
            return true;
        }
        if (this.myIsAttemptReconnect) {
            try {
                this.myActiveDatabase.createConnection();
            }
            catch (DatabaseException e) {
                Log.e((String)Datastore.class.getSimpleName(), (String)("Failed to recreate a connection to the database [" + e + "]"));
                return false;
            }
            return true;
        }
        return false;
    }

    private void executeStmt(DatabaseTask task) throws DatabaseException {
        if (this.isBlockingCall()) {
            task.executeTask();
        } else if (this.isTasksQueued()) {
            task.addOnTaskCompleteListener(this);
            this.addTaskToQueue(task);
        } else {
            task.Start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addTaskToQueue(DatabaseTask dt) throws DatabaseException {
        List<DatabaseTask> list = myQueuedTasks;
        synchronized (list) {
            myQueuedTasks.add(dt);
            if (myQueuedTasks.size() == 1) {
                dt.Start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskComplete(Tasker task) {
        try {
            List<DatabaseTask> list = myQueuedTasks;
            synchronized (list) {
                myQueuedTasks.remove(task);
                if (myQueuedTasks.size() > 0) {
                    myQueuedTasks.get(0).Start();
                }
            }
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }
}

