/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.imageviewer;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.core.content.ContextCompat;
import com.stfalcon.imageviewer.R;
import com.stfalcon.imageviewer.listeners.OnDismissListener;
import com.stfalcon.imageviewer.listeners.OnImageChangeListener;
import com.stfalcon.imageviewer.loader.ImageLoader;
import com.stfalcon.imageviewer.viewer.builder.BuilderData;
import com.stfalcon.imageviewer.viewer.dialog.ImageViewerDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StfalconImageViewer<T> {
    private Context context;
    private BuilderData<T> builderData;
    private ImageViewerDialog<T> dialog;

    protected StfalconImageViewer(@NonNull Context context, @NonNull BuilderData<T> builderData) {
        this.context = context;
        this.builderData = builderData;
        this.dialog = new ImageViewerDialog<T>(context, builderData);
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean animate) {
        if (!this.builderData.getImages().isEmpty()) {
            this.dialog.show(animate);
        } else {
            Log.w((String)this.context.getString(R.string.library_name), (String)"Images list cannot be empty! Viewer ignored.");
        }
    }

    public void close() {
        this.dialog.close();
    }

    public void dismiss() {
        this.dialog.dismiss();
    }

    public void updateImages(T[] images) {
        this.updateImages(new ArrayList<T>(Arrays.asList(images)));
    }

    public void updateImages(List<T> images) {
        if (!images.isEmpty()) {
            this.dialog.updateImages(images);
        } else {
            this.dialog.close();
        }
    }

    public int currentPosition() {
        return this.dialog.getCurrentPosition();
    }

    public int setCurrentPosition(int position) {
        return this.dialog.setCurrentPosition(position);
    }

    public void updateTransitionImage(ImageView imageView) {
        this.dialog.updateTransitionImage(imageView);
    }

    public static class Builder<T> {
        private Context context;
        private BuilderData<T> data;

        public Builder(Context context, T[] images, ImageLoader<T> imageLoader) {
            this(context, new ArrayList<T>(Arrays.asList(images)), imageLoader);
        }

        public Builder(Context context, List<T> images, ImageLoader<T> imageLoader) {
            this.context = context;
            this.data = new BuilderData<T>(images, imageLoader);
        }

        public Builder<T> withStartPosition(int position) {
            this.data.setStartPosition(position);
            return this;
        }

        public Builder<T> withBackgroundColor(@ColorInt int color) {
            this.data.setBackgroundColor(color);
            return this;
        }

        public Builder<T> withBackgroundColorResource(@ColorRes int color) {
            return this.withBackgroundColor(ContextCompat.getColor((Context)this.context, (int)color));
        }

        public Builder<T> withOverlayView(View view) {
            this.data.setOverlayView(view);
            return this;
        }

        public Builder<T> withImagesMargin(@DimenRes int dimen) {
            this.data.setImageMarginPixels(Math.round(this.context.getResources().getDimension(dimen)));
            return this;
        }

        public Builder<T> withImageMarginPixels(int marginPixels) {
            this.data.setImageMarginPixels(marginPixels);
            return this;
        }

        public Builder<T> withContainerPadding(@DimenRes int padding) {
            int paddingPx = Math.round(this.context.getResources().getDimension(padding));
            return this.withContainerPaddingPixels(paddingPx, paddingPx, paddingPx, paddingPx);
        }

        public Builder<T> withContainerPadding(@DimenRes int start, @DimenRes int top, @DimenRes int end, @DimenRes int bottom) {
            this.withContainerPaddingPixels(Math.round(this.context.getResources().getDimension(start)), Math.round(this.context.getResources().getDimension(top)), Math.round(this.context.getResources().getDimension(end)), Math.round(this.context.getResources().getDimension(bottom)));
            return this;
        }

        public Builder<T> withContainerPaddingPixels(@Px int padding) {
            this.data.setContainerPaddingPixels(new int[]{padding, padding, padding, padding});
            return this;
        }

        public Builder<T> withContainerPaddingPixels(int start, int top, int end, int bottom) {
            this.data.setContainerPaddingPixels(new int[]{start, top, end, bottom});
            return this;
        }

        public Builder<T> withHiddenStatusBar(boolean value) {
            this.data.setShouldStatusBarHide(value);
            return this;
        }

        public Builder<T> allowZooming(boolean value) {
            this.data.setZoomingAllowed(value);
            return this;
        }

        public Builder<T> allowSwipeToDismiss(boolean value) {
            this.data.setSwipeToDismissAllowed(value);
            return this;
        }

        public Builder<T> withTransitionFrom(ImageView imageView) {
            this.data.setTransitionView(imageView);
            return this;
        }

        public Builder<T> withImageChangeListener(OnImageChangeListener imageChangeListener) {
            this.data.setImageChangeListener(imageChangeListener);
            return this;
        }

        public Builder<T> withDismissListener(OnDismissListener onDismissListener) {
            this.data.setOnDismissListener(onDismissListener);
            return this;
        }

        public StfalconImageViewer<T> build() {
            return new StfalconImageViewer<T>(this.context, this.data);
        }

        public StfalconImageViewer<T> show() {
            return this.show(true);
        }

        public StfalconImageViewer<T> show(boolean animate) {
            StfalconImageViewer<T> viewer = this.build();
            viewer.show(animate);
            return viewer;
        }
    }
}

