/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.chatkit.messages;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.core.graphics.drawable.DrawableCompat;
import com.stfalcon.chatkit.R;
import com.stfalcon.chatkit.commons.Style;

class MessagesListStyle
extends Style {
    private int textAutoLinkMask;
    private int incomingTextLinkColor;
    private int outcomingTextLinkColor;
    private int incomingAvatarWidth;
    private int incomingAvatarHeight;
    private int incomingBubbleDrawable;
    private int incomingDefaultBubbleColor;
    private int incomingDefaultBubblePressedColor;
    private int incomingDefaultBubbleSelectedColor;
    private int incomingImageOverlayDrawable;
    private int incomingDefaultImageOverlayPressedColor;
    private int incomingDefaultImageOverlaySelectedColor;
    private int incomingDefaultBubblePaddingLeft;
    private int incomingDefaultBubblePaddingRight;
    private int incomingDefaultBubblePaddingTop;
    private int incomingDefaultBubblePaddingBottom;
    private int incomingTextColor;
    private int incomingTextSize;
    private int incomingTextStyle;
    private int incomingTimeTextColor;
    private int incomingTimeTextSize;
    private int incomingTimeTextStyle;
    private int incomingImageTimeTextColor;
    private int incomingImageTimeTextSize;
    private int incomingImageTimeTextStyle;
    private int outcomingBubbleDrawable;
    private int outcomingDefaultBubbleColor;
    private int outcomingDefaultBubblePressedColor;
    private int outcomingDefaultBubbleSelectedColor;
    private int outcomingImageOverlayDrawable;
    private int outcomingDefaultImageOverlayPressedColor;
    private int outcomingDefaultImageOverlaySelectedColor;
    private int outcomingDefaultBubblePaddingLeft;
    private int outcomingDefaultBubblePaddingRight;
    private int outcomingDefaultBubblePaddingTop;
    private int outcomingDefaultBubblePaddingBottom;
    private int outcomingTextColor;
    private int outcomingTextSize;
    private int outcomingTextStyle;
    private int outcomingTimeTextColor;
    private int outcomingTimeTextSize;
    private int outcomingTimeTextStyle;
    private int outcomingImageTimeTextColor;
    private int outcomingImageTimeTextSize;
    private int outcomingImageTimeTextStyle;
    private int dateHeaderPadding;
    private String dateHeaderFormat;
    private int dateHeaderTextColor;
    private int dateHeaderTextSize;
    private int dateHeaderTextStyle;

    static MessagesListStyle parse(Context context, AttributeSet attrs) {
        MessagesListStyle style = new MessagesListStyle(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MessagesList);
        style.textAutoLinkMask = typedArray.getInt(R.styleable.MessagesList_textAutoLink, 0);
        style.incomingTextLinkColor = typedArray.getColor(R.styleable.MessagesList_incomingTextLinkColor, style.getSystemAccentColor());
        style.outcomingTextLinkColor = typedArray.getColor(R.styleable.MessagesList_outcomingTextLinkColor, style.getSystemAccentColor());
        style.incomingAvatarWidth = typedArray.getDimensionPixelSize(R.styleable.MessagesList_incomingAvatarWidth, style.getDimension(R.dimen.message_avatar_width));
        style.incomingAvatarHeight = typedArray.getDimensionPixelSize(R.styleable.MessagesList_incomingAvatarHeight, style.getDimension(R.dimen.message_avatar_height));
        style.incomingBubbleDrawable = typedArray.getResourceId(R.styleable.MessagesList_incomingBubbleDrawable, -1);
        style.incomingDefaultBubbleColor = typedArray.getColor(R.styleable.MessagesList_incomingDefaultBubbleColor, style.getColor(R.color.white_two));
        style.incomingDefaultBubblePressedColor = typedArray.getColor(R.styleable.MessagesList_incomingDefaultBubblePressedColor, style.getColor(R.color.white_two));
        style.incomingDefaultBubbleSelectedColor = typedArray.getColor(R.styleable.MessagesList_incomingDefaultBubbleSelectedColor, style.getColor(R.color.cornflower_blue_two_24));
        style.incomingImageOverlayDrawable = typedArray.getResourceId(R.styleable.MessagesList_incomingImageOverlayDrawable, -1);
        style.incomingDefaultImageOverlayPressedColor = typedArray.getColor(R.styleable.MessagesList_incomingDefaultImageOverlayPressedColor, style.getColor(R.color.transparent));
        style.incomingDefaultImageOverlaySelectedColor = typedArray.getColor(R.styleable.MessagesList_incomingDefaultImageOverlaySelectedColor, style.getColor(R.color.cornflower_blue_light_40));
        style.incomingDefaultBubblePaddingLeft = typedArray.getDimensionPixelSize(R.styleable.MessagesList_incomingBubblePaddingLeft, style.getDimension(R.dimen.message_padding_left));
        style.incomingDefaultBubblePaddingRight = typedArray.getDimensionPixelSize(R.styleable.MessagesList_incomingBubblePaddingRight, style.getDimension(R.dimen.message_padding_right));
        style.incomingDefaultBubblePaddingTop = typedArray.getDimensionPixelSize(R.styleable.MessagesList_incomingBubblePaddingTop, style.getDimension(R.dimen.message_padding_top));
        style.incomingDefaultBubblePaddingBottom = typedArray.getDimensionPixelSize(R.styleable.MessagesList_incomingBubblePaddingBottom, style.getDimension(R.dimen.message_padding_bottom));
        style.incomingTextColor = typedArray.getColor(R.styleable.MessagesList_incomingTextColor, style.getColor(R.color.dark_grey_two));
        style.incomingTextSize = typedArray.getDimensionPixelSize(R.styleable.MessagesList_incomingTextSize, style.getDimension(R.dimen.message_text_size));
        style.incomingTextStyle = typedArray.getInt(R.styleable.MessagesList_incomingTextStyle, 0);
        style.incomingTimeTextColor = typedArray.getColor(R.styleable.MessagesList_incomingTimeTextColor, style.getColor(R.color.warm_grey_four));
        style.incomingTimeTextSize = typedArray.getDimensionPixelSize(R.styleable.MessagesList_incomingTimeTextSize, style.getDimension(R.dimen.message_time_text_size));
        style.incomingTimeTextStyle = typedArray.getInt(R.styleable.MessagesList_incomingTimeTextStyle, 0);
        style.incomingImageTimeTextColor = typedArray.getColor(R.styleable.MessagesList_incomingImageTimeTextColor, style.getColor(R.color.warm_grey_four));
        style.incomingImageTimeTextSize = typedArray.getDimensionPixelSize(R.styleable.MessagesList_incomingImageTimeTextSize, style.getDimension(R.dimen.message_time_text_size));
        style.incomingImageTimeTextStyle = typedArray.getInt(R.styleable.MessagesList_incomingImageTimeTextStyle, 0);
        style.outcomingBubbleDrawable = typedArray.getResourceId(R.styleable.MessagesList_outcomingBubbleDrawable, -1);
        style.outcomingDefaultBubbleColor = typedArray.getColor(R.styleable.MessagesList_outcomingDefaultBubbleColor, style.getColor(R.color.cornflower_blue_two));
        style.outcomingDefaultBubblePressedColor = typedArray.getColor(R.styleable.MessagesList_outcomingDefaultBubblePressedColor, style.getColor(R.color.cornflower_blue_two));
        style.outcomingDefaultBubbleSelectedColor = typedArray.getColor(R.styleable.MessagesList_outcomingDefaultBubbleSelectedColor, style.getColor(R.color.cornflower_blue_two_24));
        style.outcomingImageOverlayDrawable = typedArray.getResourceId(R.styleable.MessagesList_outcomingImageOverlayDrawable, -1);
        style.outcomingDefaultImageOverlayPressedColor = typedArray.getColor(R.styleable.MessagesList_outcomingDefaultImageOverlayPressedColor, style.getColor(R.color.transparent));
        style.outcomingDefaultImageOverlaySelectedColor = typedArray.getColor(R.styleable.MessagesList_outcomingDefaultImageOverlaySelectedColor, style.getColor(R.color.cornflower_blue_light_40));
        style.outcomingDefaultBubblePaddingLeft = typedArray.getDimensionPixelSize(R.styleable.MessagesList_outcomingBubblePaddingLeft, style.getDimension(R.dimen.message_padding_left));
        style.outcomingDefaultBubblePaddingRight = typedArray.getDimensionPixelSize(R.styleable.MessagesList_outcomingBubblePaddingRight, style.getDimension(R.dimen.message_padding_right));
        style.outcomingDefaultBubblePaddingTop = typedArray.getDimensionPixelSize(R.styleable.MessagesList_outcomingBubblePaddingTop, style.getDimension(R.dimen.message_padding_top));
        style.outcomingDefaultBubblePaddingBottom = typedArray.getDimensionPixelSize(R.styleable.MessagesList_outcomingBubblePaddingBottom, style.getDimension(R.dimen.message_padding_bottom));
        style.outcomingTextColor = typedArray.getColor(R.styleable.MessagesList_outcomingTextColor, style.getColor(R.color.white));
        style.outcomingTextSize = typedArray.getDimensionPixelSize(R.styleable.MessagesList_outcomingTextSize, style.getDimension(R.dimen.message_text_size));
        style.outcomingTextStyle = typedArray.getInt(R.styleable.MessagesList_outcomingTextStyle, 0);
        style.outcomingTimeTextColor = typedArray.getColor(R.styleable.MessagesList_outcomingTimeTextColor, style.getColor(R.color.white60));
        style.outcomingTimeTextSize = typedArray.getDimensionPixelSize(R.styleable.MessagesList_outcomingTimeTextSize, style.getDimension(R.dimen.message_time_text_size));
        style.outcomingTimeTextStyle = typedArray.getInt(R.styleable.MessagesList_outcomingTimeTextStyle, 0);
        style.outcomingImageTimeTextColor = typedArray.getColor(R.styleable.MessagesList_outcomingImageTimeTextColor, style.getColor(R.color.warm_grey_four));
        style.outcomingImageTimeTextSize = typedArray.getDimensionPixelSize(R.styleable.MessagesList_outcomingImageTimeTextSize, style.getDimension(R.dimen.message_time_text_size));
        style.outcomingImageTimeTextStyle = typedArray.getInt(R.styleable.MessagesList_outcomingImageTimeTextStyle, 0);
        style.dateHeaderPadding = typedArray.getDimensionPixelSize(R.styleable.MessagesList_dateHeaderPadding, style.getDimension(R.dimen.message_date_header_padding));
        style.dateHeaderFormat = typedArray.getString(R.styleable.MessagesList_dateHeaderFormat);
        style.dateHeaderTextColor = typedArray.getColor(R.styleable.MessagesList_dateHeaderTextColor, style.getColor(R.color.warm_grey_two));
        style.dateHeaderTextSize = typedArray.getDimensionPixelSize(R.styleable.MessagesList_dateHeaderTextSize, style.getDimension(R.dimen.message_date_header_text_size));
        style.dateHeaderTextStyle = typedArray.getInt(R.styleable.MessagesList_dateHeaderTextStyle, 0);
        typedArray.recycle();
        return style;
    }

    private MessagesListStyle(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private Drawable getMessageSelector(@ColorInt int normalColor, @ColorInt int selectedColor, @ColorInt int pressedColor, @DrawableRes int shape) {
        Drawable drawable2 = DrawableCompat.wrap((Drawable)this.getVectorDrawable(shape)).mutate();
        DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)new ColorStateList((int[][])new int[][]{{0x10100A1}, {16842919}, {-16842919, -16842913}}, new int[]{selectedColor, pressedColor, normalColor}));
        return drawable2;
    }

    protected int getTextAutoLinkMask() {
        return this.textAutoLinkMask;
    }

    protected int getIncomingTextLinkColor() {
        return this.incomingTextLinkColor;
    }

    protected int getOutcomingTextLinkColor() {
        return this.outcomingTextLinkColor;
    }

    protected int getIncomingAvatarWidth() {
        return this.incomingAvatarWidth;
    }

    protected int getIncomingAvatarHeight() {
        return this.incomingAvatarHeight;
    }

    protected int getIncomingDefaultBubblePaddingLeft() {
        return this.incomingDefaultBubblePaddingLeft;
    }

    protected int getIncomingDefaultBubblePaddingRight() {
        return this.incomingDefaultBubblePaddingRight;
    }

    protected int getIncomingDefaultBubblePaddingTop() {
        return this.incomingDefaultBubblePaddingTop;
    }

    protected int getIncomingDefaultBubblePaddingBottom() {
        return this.incomingDefaultBubblePaddingBottom;
    }

    protected int getIncomingTextColor() {
        return this.incomingTextColor;
    }

    protected int getIncomingTextSize() {
        return this.incomingTextSize;
    }

    protected int getIncomingTextStyle() {
        return this.incomingTextStyle;
    }

    protected Drawable getOutcomingBubbleDrawable() {
        if (this.outcomingBubbleDrawable == -1) {
            return this.getMessageSelector(this.outcomingDefaultBubbleColor, this.outcomingDefaultBubbleSelectedColor, this.outcomingDefaultBubblePressedColor, R.drawable.shape_outcoming_message);
        }
        return this.getDrawable(this.outcomingBubbleDrawable);
    }

    protected Drawable getOutcomingImageOverlayDrawable() {
        if (this.outcomingImageOverlayDrawable == -1) {
            return this.getMessageSelector(0, this.outcomingDefaultImageOverlaySelectedColor, this.outcomingDefaultImageOverlayPressedColor, R.drawable.shape_outcoming_message);
        }
        return this.getDrawable(this.outcomingImageOverlayDrawable);
    }

    protected int getOutcomingDefaultBubblePaddingLeft() {
        return this.outcomingDefaultBubblePaddingLeft;
    }

    protected int getOutcomingDefaultBubblePaddingRight() {
        return this.outcomingDefaultBubblePaddingRight;
    }

    protected int getOutcomingDefaultBubblePaddingTop() {
        return this.outcomingDefaultBubblePaddingTop;
    }

    protected int getOutcomingDefaultBubblePaddingBottom() {
        return this.outcomingDefaultBubblePaddingBottom;
    }

    protected int getOutcomingTextColor() {
        return this.outcomingTextColor;
    }

    protected int getOutcomingTextSize() {
        return this.outcomingTextSize;
    }

    protected int getOutcomingTextStyle() {
        return this.outcomingTextStyle;
    }

    protected int getOutcomingTimeTextColor() {
        return this.outcomingTimeTextColor;
    }

    protected int getOutcomingTimeTextSize() {
        return this.outcomingTimeTextSize;
    }

    protected int getOutcomingTimeTextStyle() {
        return this.outcomingTimeTextStyle;
    }

    protected int getOutcomingImageTimeTextColor() {
        return this.outcomingImageTimeTextColor;
    }

    protected int getOutcomingImageTimeTextSize() {
        return this.outcomingImageTimeTextSize;
    }

    protected int getOutcomingImageTimeTextStyle() {
        return this.outcomingImageTimeTextStyle;
    }

    protected int getDateHeaderTextColor() {
        return this.dateHeaderTextColor;
    }

    protected int getDateHeaderTextSize() {
        return this.dateHeaderTextSize;
    }

    protected int getDateHeaderTextStyle() {
        return this.dateHeaderTextStyle;
    }

    protected int getDateHeaderPadding() {
        return this.dateHeaderPadding;
    }

    protected String getDateHeaderFormat() {
        return this.dateHeaderFormat;
    }

    protected int getIncomingTimeTextSize() {
        return this.incomingTimeTextSize;
    }

    protected int getIncomingTimeTextStyle() {
        return this.incomingTimeTextStyle;
    }

    protected int getIncomingTimeTextColor() {
        return this.incomingTimeTextColor;
    }

    protected int getIncomingImageTimeTextColor() {
        return this.incomingImageTimeTextColor;
    }

    protected int getIncomingImageTimeTextSize() {
        return this.incomingImageTimeTextSize;
    }

    protected int getIncomingImageTimeTextStyle() {
        return this.incomingImageTimeTextStyle;
    }

    protected Drawable getIncomingBubbleDrawable() {
        if (this.incomingBubbleDrawable == -1) {
            return this.getMessageSelector(this.incomingDefaultBubbleColor, this.incomingDefaultBubbleSelectedColor, this.incomingDefaultBubblePressedColor, R.drawable.shape_incoming_message);
        }
        return this.getDrawable(this.incomingBubbleDrawable);
    }

    protected Drawable getIncomingImageOverlayDrawable() {
        if (this.incomingImageOverlayDrawable == -1) {
            return this.getMessageSelector(0, this.incomingDefaultImageOverlaySelectedColor, this.incomingDefaultImageOverlayPressedColor, R.drawable.shape_incoming_message);
        }
        return this.getDrawable(this.incomingImageOverlayDrawable);
    }
}

