/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib;

import com.github.steveice10.packetlib.Server;
import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.event.server.ServerBoundEvent;
import com.github.steveice10.packetlib.event.server.ServerClosedEvent;
import com.github.steveice10.packetlib.event.server.ServerClosingEvent;
import com.github.steveice10.packetlib.event.server.ServerEvent;
import com.github.steveice10.packetlib.event.server.ServerListener;
import com.github.steveice10.packetlib.event.server.SessionAddedEvent;
import com.github.steveice10.packetlib.event.server.SessionRemovedEvent;
import com.github.steveice10.packetlib.packet.PacketProtocol;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractServer
implements Server {
    private final String host;
    private final int port;
    private final Class<? extends PacketProtocol> protocol;
    private final List<Session> sessions = new ArrayList<Session>();
    private final Map<String, Object> flags = new HashMap<String, Object>();
    private final List<ServerListener> listeners = new ArrayList<ServerListener>();

    public AbstractServer(String host, int port, Class<? extends PacketProtocol> protocol) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Class<? extends PacketProtocol> getPacketProtocol() {
        return this.protocol;
    }

    protected PacketProtocol createPacketProtocol() {
        try {
            Constructor<? extends PacketProtocol> constructor = this.protocol.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodError e) {
            throw new IllegalStateException("PacketProtocol \"" + this.protocol.getName() + "\" does not have a no-params constructor for instantiation.");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate PacketProtocol " + this.protocol.getName() + ".", e);
        }
    }

    @Override
    public Map<String, Object> getGlobalFlags() {
        return Collections.unmodifiableMap(this.flags);
    }

    @Override
    public boolean hasGlobalFlag(String key) {
        return this.flags.containsKey(key);
    }

    @Override
    public <T> T getGlobalFlag(String key) {
        return this.getGlobalFlag(key, null);
    }

    @Override
    public <T> T getGlobalFlag(String key, T def) {
        Object value = this.flags.get(key);
        if (value == null) {
            return def;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Tried to get flag \"" + key + "\" as the wrong type. Actual type: " + value.getClass().getName());
        }
    }

    @Override
    public void setGlobalFlag(String key, Object value) {
        this.flags.put(key, value);
    }

    @Override
    public List<ServerListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void addListener(ServerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    protected void callEvent(ServerEvent event) {
        for (ServerListener listener : this.listeners) {
            event.call(listener);
        }
    }

    @Override
    public List<Session> getSessions() {
        return new ArrayList<Session>(this.sessions);
    }

    public void addSession(Session session) {
        this.sessions.add(session);
        this.callEvent(new SessionAddedEvent(this, session));
    }

    public void removeSession(Session session) {
        this.sessions.remove(session);
        if (session.isConnected()) {
            session.disconnect("Connection closed.");
        }
        this.callEvent(new SessionRemovedEvent(this, session));
    }

    @Override
    public AbstractServer bind() {
        return this.bind(true);
    }

    @Override
    public AbstractServer bind(boolean wait) {
        return this.bind(wait, null);
    }

    @Override
    public AbstractServer bind(boolean wait, Runnable callback) {
        this.bindImpl(wait, () -> {
            this.callEvent(new ServerBoundEvent(this));
            if (callback != null) {
                callback.run();
            }
        });
        return this;
    }

    protected abstract void bindImpl(boolean var1, Runnable var2);

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void close(boolean wait) {
        this.close(wait, null);
    }

    @Override
    public void close(boolean wait, Runnable callback) {
        this.callEvent(new ServerClosingEvent(this));
        for (Session session : this.getSessions()) {
            if (!session.isConnected()) continue;
            session.disconnect("Server closed.");
        }
        this.closeImpl(wait, () -> {
            this.callEvent(new ServerClosedEvent(this));
            if (callback != null) {
                callback.run();
            }
        });
    }

    protected abstract void closeImpl(boolean var1, Runnable var2);
}

