/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib;

import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.SessionFactory;
import com.github.steveice10.packetlib.packet.PacketProtocol;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;

public class Client {
    private String host;
    private int port;
    private String bindAddress;
    private int bindPort;
    private PacketProtocol protocol;
    private Session session;

    public Client(String host, int port, String bindAddress, int bindPort, PacketProtocol protocol, SessionFactory factory) {
        this.host = host;
        this.port = port;
        this.bindAddress = bindAddress;
        this.bindPort = bindPort;
        this.protocol = protocol;
        this.session = factory.createClientSession(this);
    }

    public Client(String host, int port, PacketProtocol protocol, SessionFactory factory) {
        this(host, port, "0.0.0.0", 0, protocol, factory);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getBindAddress() {
        Session session = this.getSession();
        return session.isConnected() ? ((InetSocketAddress)session.getLocalAddress()).getAddress().getHostAddress() : this.bindAddress;
    }

    public int getBindPort() {
        Session session = this.getSession();
        return session.isConnected() ? ((InetSocketAddress)session.getLocalAddress()).getPort() : this.bindPort;
    }

    public PacketProtocol getPacketProtocol() {
        return this.protocol;
    }

    public Session getSession() {
        return this.session;
    }
}

