/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.tcp;

import com.github.steveice10.packetlib.Client;
import com.github.steveice10.packetlib.ProxyInfo;
import com.github.steveice10.packetlib.packet.PacketProtocol;
import com.github.steveice10.packetlib.tcp.TcpPacketCodec;
import com.github.steveice10.packetlib.tcp.TcpPacketEncryptor;
import com.github.steveice10.packetlib.tcp.TcpPacketSizer;
import com.github.steveice10.packetlib.tcp.TcpSession;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class TcpClientSession
extends TcpSession {
    private Client client;
    private ProxyInfo proxy;
    private EventLoopGroup group;

    public TcpClientSession(String host, int port, PacketProtocol protocol, Client client, ProxyInfo proxy) {
        super(host, port, protocol);
        this.client = client;
        this.proxy = proxy;
    }

    @Override
    public void connect(boolean wait) {
        if (this.disconnected) {
            throw new IllegalStateException("Session has already been disconnected.");
        }
        if (this.group != null) {
            return;
        }
        try {
            this.group = new NioEventLoopGroup();
            final Bootstrap bootstrap = new Bootstrap();
            bootstrap.channel(NioSocketChannel.class);
            ((Bootstrap)((Bootstrap)bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel channel) throws Exception {
                    TcpClientSession.this.getPacketProtocol().newClientSession(TcpClientSession.this.client, TcpClientSession.this);
                    channel.config().setOption(ChannelOption.IP_TOS, (Object)24);
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)false);
                    ChannelPipeline pipeline = channel.pipeline();
                    TcpClientSession.this.refreshReadTimeoutHandler(channel);
                    TcpClientSession.this.refreshWriteTimeoutHandler(channel);
                    if (TcpClientSession.this.proxy != null) {
                        switch (TcpClientSession.this.proxy.getType()) {
                            case HTTP: {
                                if (TcpClientSession.this.proxy.isAuthenticated()) {
                                    pipeline.addFirst("proxy", (ChannelHandler)new HttpProxyHandler(TcpClientSession.this.proxy.getAddress(), TcpClientSession.this.proxy.getUsername(), TcpClientSession.this.proxy.getPassword()));
                                    break;
                                }
                                pipeline.addFirst("proxy", (ChannelHandler)new HttpProxyHandler(TcpClientSession.this.proxy.getAddress()));
                                break;
                            }
                            case SOCKS4: {
                                if (TcpClientSession.this.proxy.isAuthenticated()) {
                                    pipeline.addFirst("proxy", (ChannelHandler)new Socks4ProxyHandler(TcpClientSession.this.proxy.getAddress(), TcpClientSession.this.proxy.getUsername()));
                                    break;
                                }
                                pipeline.addFirst("proxy", (ChannelHandler)new Socks4ProxyHandler(TcpClientSession.this.proxy.getAddress()));
                                break;
                            }
                            case SOCKS5: {
                                if (TcpClientSession.this.proxy.isAuthenticated()) {
                                    pipeline.addFirst("proxy", (ChannelHandler)new Socks5ProxyHandler(TcpClientSession.this.proxy.getAddress(), TcpClientSession.this.proxy.getUsername(), TcpClientSession.this.proxy.getPassword()));
                                    break;
                                }
                                pipeline.addFirst("proxy", (ChannelHandler)new Socks5ProxyHandler(TcpClientSession.this.proxy.getAddress()));
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unsupported proxy type: " + (Object)((Object)TcpClientSession.this.proxy.getType()));
                            }
                        }
                    }
                    pipeline.addLast("encryption", (ChannelHandler)new TcpPacketEncryptor(TcpClientSession.this));
                    pipeline.addLast("sizer", (ChannelHandler)new TcpPacketSizer(TcpClientSession.this));
                    pipeline.addLast("codec", (ChannelHandler)new TcpPacketCodec(TcpClientSession.this));
                    pipeline.addLast("manager", (ChannelHandler)TcpClientSession.this);
                }
            })).group(this.group)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(this.getConnectTimeout() * 1000));
            Runnable connectTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        bootstrap.remoteAddress(TcpClientSession.this.resolveAddress());
                        ChannelFuture future = bootstrap.connect().sync();
                        if (future.isSuccess()) {
                            while (!TcpClientSession.this.isConnected() && !TcpClientSession.this.disconnected) {
                                try {
                                    Thread.sleep(5L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                    catch (Throwable t) {
                        TcpClientSession.this.exceptionCaught(null, t);
                    }
                }
            };
            if (wait) {
                connectTask.run();
            } else {
                new Thread(connectTask).start();
            }
        }
        catch (Throwable t) {
            this.exceptionCaught(null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress resolveAddress() {
        boolean debug = this.getFlag("print-packetlib-debug", false);
        String name = this.getPacketProtocol().getSRVRecordPrefix() + "._tcp." + this.getHost();
        if (debug) {
            System.out.println("[PacketLib] Attempting SRV lookup for \"" + name + "\".");
        }
        AddressedEnvelope envelope = null;
        try (DnsNameResolver resolver = new DnsNameResolverBuilder(this.group.next()).channelType(NioDatagramChannel.class).build();){
            envelope = (AddressedEnvelope)resolver.query((DnsQuestion)new DefaultDnsQuestion(name, DnsRecordType.SRV)).get();
            DnsResponse response = (DnsResponse)envelope.content();
            if (response.count(DnsSection.ANSWER) > 0) {
                DefaultDnsRawRecord record = (DefaultDnsRawRecord)response.recordAt(DnsSection.ANSWER, 0);
                if (record.type() == DnsRecordType.SRV) {
                    ByteBuf buf = record.content();
                    buf.skipBytes(4);
                    int port = buf.readUnsignedShort();
                    String host = DefaultDnsRecordDecoder.decodeName((ByteBuf)buf);
                    if (host.endsWith(".")) {
                        host = host.substring(0, host.length() - 1);
                    }
                    if (debug) {
                        System.out.println("[PacketLib] Found SRV record containing \"" + host + ":" + port + "\".");
                    }
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(host, port);
                    return inetSocketAddress;
                }
                if (debug) {
                    System.out.println("[PacketLib] Received non-SRV record in response.");
                }
            } else if (debug) {
                System.out.println("[PacketLib] No SRV record found.");
            }
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("[PacketLib] Failed to resolve SRV record.");
                e.printStackTrace();
            }
        }
        finally {
            if (envelope != null) {
                envelope.release();
            }
        }
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    @Override
    public void disconnect(String reason, Throwable cause) {
        super.disconnect(reason, cause);
        if (this.group != null) {
            this.group.shutdownGracefully();
            this.group = null;
        }
    }
}

