/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.codec;

import com.github.steveice10.packetlib.codec.PacketCodecHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;

public class BasePacketCodecHelper
implements PacketCodecHelper {
    @Override
    public void writeVarInt(ByteBuf buf, int value) {
        this.writeVarLong(buf, (long)value & 0xFFFFFFFFL);
    }

    @Override
    public int readVarInt(ByteBuf buf) {
        byte b;
        int value = 0;
        int size = 0;
        while (((b = buf.readByte()) & 0x80) == 128) {
            value |= (b & 0x7F) << size++ * 7;
            if (size <= 5) continue;
            throw new IllegalArgumentException("VarInt too long (length must be <= 5)");
        }
        return value | (b & 0x7F) << size * 7;
    }

    @Override
    public void writeVarLong(ByteBuf buf, long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buf.writeByte((int)((byte)value));
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 8 | value >>> 7);
            buf.writeShort(w);
        } else {
            BasePacketCodecHelper.writeVarLongFull(buf, value);
        }
    }

    private static void writeVarLongFull(ByteBuf buf, long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buf.writeByte((int)((byte)value));
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 8 | value >>> 7);
            buf.writeShort(w);
        } else if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 16 | (value >>> 7 & 0x7FL | 0x80L) << 8 | value >>> 14);
            buf.writeMedium(w);
        } else if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | value >>> 21);
            buf.writeInt(w);
        } else if ((value & 0xFFFFFFF800000000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | (value >>> 21 & 0x7FL | 0x80L));
            buf.writeInt(w);
            buf.writeByte((int)(value >>> 28));
        } else if ((value & 0xFFFFFC0000000000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | (value >>> 21 & 0x7FL | 0x80L));
            int w2 = (int)((value >>> 28 & 0x7FL | 0x80L) << 8 | value >>> 35);
            buf.writeInt(w);
            buf.writeShort(w2);
        } else if ((value & 0xFFFE000000000000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | (value >>> 21 & 0x7FL | 0x80L));
            int w2 = (int)((value >>> 28 & 0x7FL | 0x80L) << 16 | (value >>> 35 & 0x7FL | 0x80L) << 8 | value >>> 42);
            buf.writeInt(w);
            buf.writeMedium(w2);
        } else if ((value & 0xFF00000000000000L) == 0L) {
            long w = (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | value >>> 49;
            buf.writeLong(w);
        } else if ((value & Long.MIN_VALUE) == 0L) {
            long w = (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | value >>> 49;
            buf.writeLong(w);
            buf.writeByte((int)((byte)(value >>> 56)));
        } else {
            long w = (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | value >>> 49;
            int w2 = (int)((value >>> 56 & 0x7FL | 0x80L) << 8 | value >>> 63);
            buf.writeLong(w);
            buf.writeShort(w2);
        }
    }

    @Override
    public long readVarLong(ByteBuf buf) {
        byte b;
        int value = 0;
        int size = 0;
        while (((b = buf.readByte()) & 0x80) == 128) {
            value |= (b & 0x7F) << size++ * 7;
            if (size <= 10) continue;
            throw new IllegalArgumentException("VarLong too long (length must be <= 10)");
        }
        return (long)value | ((long)b & 0x7FL) << size * 7;
    }

    @Override
    public String readString(ByteBuf buf) {
        return this.readString(buf, Short.MAX_VALUE);
    }

    @Override
    public String readString(ByteBuf buf, int maxLength) {
        int length = this.readVarInt(buf);
        if (length > maxLength * 3) {
            throw new IllegalArgumentException("String buffer is longer than maximum allowed length");
        }
        String string = (String)buf.readCharSequence(length, StandardCharsets.UTF_8);
        if (string.length() > maxLength) {
            throw new IllegalArgumentException("String is longer than maximum allowed length");
        }
        return string;
    }

    @Override
    public void writeString(ByteBuf buf, String value) {
        this.writeVarInt(buf, ByteBufUtil.utf8Bytes((CharSequence)value));
        buf.writeCharSequence((CharSequence)value, StandardCharsets.UTF_8);
    }
}

