/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundTagQueryPacket
implements MinecraftPacket {
    private final int transactionId;
    @NonNull
    private final CompoundTag nbt;

    public ClientboundTagQueryPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.transactionId = helper.readVarInt(in);
        this.nbt = helper.readAnyTag(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.transactionId);
        helper.writeAnyTag(out, this.nbt);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @NonNull
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTagQueryPacket)) {
            return false;
        }
        ClientboundTagQueryPacket other = (ClientboundTagQueryPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        CompoundTag this$nbt = this.getNbt();
        CompoundTag other$nbt = other.getNbt();
        return !(this$nbt == null ? other$nbt != null : !this$nbt.equals(other$nbt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundTagQueryPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        CompoundTag $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : $nbt.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundTagQueryPacket(transactionId=" + this.getTransactionId() + ", nbt=" + this.getNbt() + ")";
    }

    public ClientboundTagQueryPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ClientboundTagQueryPacket(transactionId, this.nbt);
    }

    public ClientboundTagQueryPacket withNbt(@NonNull CompoundTag nbt) {
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        return this.nbt == nbt ? this : new ClientboundTagQueryPacket(this.transactionId, nbt);
    }

    public ClientboundTagQueryPacket(int transactionId, @NonNull CompoundTag nbt) {
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        this.transactionId = transactionId;
        this.nbt = nbt;
    }
}

