/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientboundForgetLevelChunkPacket
implements MinecraftPacket {
    private final int x;
    private final int z;

    public ClientboundForgetLevelChunkPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        long chunkPosition = in.readLong();
        this.x = (int)chunkPosition;
        this.z = (int)(chunkPosition >> 32);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeLong((long)this.x & 0xFFFFFFFFL | ((long)this.z & 0xFFFFFFFFL) << 32);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundForgetLevelChunkPacket)) {
            return false;
        }
        ClientboundForgetLevelChunkPacket other = (ClientboundForgetLevelChunkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundForgetLevelChunkPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        return result;
    }

    public String toString() {
        return "ClientboundForgetLevelChunkPacket(x=" + this.getX() + ", z=" + this.getZ() + ")";
    }

    public ClientboundForgetLevelChunkPacket withX(int x) {
        return this.x == x ? this : new ClientboundForgetLevelChunkPacket(x, this.z);
    }

    public ClientboundForgetLevelChunkPacket withZ(int z) {
        return this.z == z ? this : new ClientboundForgetLevelChunkPacket(this.x, z);
    }

    public ClientboundForgetLevelChunkPacket(int x, int z) {
        this.x = x;
        this.z = z;
    }
}

