/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.spawn;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientboundAddExperienceOrbPacket
implements MinecraftPacket {
    private final int entityId;
    private final double x;
    private final double y;
    private final double z;
    private final int exp;

    public ClientboundAddExperienceOrbPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = helper.readVarInt(in);
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.exp = in.readShort();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.entityId);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeShort(this.exp);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getExp() {
        return this.exp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAddExperienceOrbPacket)) {
            return false;
        }
        ClientboundAddExperienceOrbPacket other = (ClientboundAddExperienceOrbPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        return this.getExp() == other.getExp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAddExperienceOrbPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + this.getExp();
        return result;
    }

    public String toString() {
        return "ClientboundAddExperienceOrbPacket(entityId=" + this.getEntityId() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", exp=" + this.getExp() + ")";
    }

    public ClientboundAddExperienceOrbPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundAddExperienceOrbPacket(entityId, this.x, this.y, this.z, this.exp);
    }

    public ClientboundAddExperienceOrbPacket withX(double x) {
        return this.x == x ? this : new ClientboundAddExperienceOrbPacket(this.entityId, x, this.y, this.z, this.exp);
    }

    public ClientboundAddExperienceOrbPacket withY(double y) {
        return this.y == y ? this : new ClientboundAddExperienceOrbPacket(this.entityId, this.x, y, this.z, this.exp);
    }

    public ClientboundAddExperienceOrbPacket withZ(double z) {
        return this.z == z ? this : new ClientboundAddExperienceOrbPacket(this.entityId, this.x, this.y, z, this.exp);
    }

    public ClientboundAddExperienceOrbPacket withExp(int exp) {
        return this.exp == exp ? this : new ClientboundAddExperienceOrbPacket(this.entityId, this.x, this.y, this.z, exp);
    }

    public ClientboundAddExperienceOrbPacket(int entityId, double x, double y, double z, int exp) {
        this.entityId = entityId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.exp = exp;
    }
}

