/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.PlayerListEntry;
import com.github.steveice10.mc.protocol.data.game.PlayerListEntryAction;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import net.kyori.adventure.text.Component;

public class ClientboundPlayerInfoUpdatePacket
implements MinecraftPacket {
    private final EnumSet<PlayerListEntryAction> actions;
    private final PlayerListEntry[] entries;

    public ClientboundPlayerInfoUpdatePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.actions = helper.readEnumSet(in, PlayerListEntryAction.VALUES);
        this.entries = new PlayerListEntry[helper.readVarInt(in)];
        for (int count = 0; count < this.entries.length; ++count) {
            PlayerListEntry entry = new PlayerListEntry(helper.readUUID(in));
            for (PlayerListEntryAction action : this.actions) {
                switch (action) {
                    case ADD_PLAYER: {
                        GameProfile profile = new GameProfile(entry.getProfileId(), helper.readString(in, 16));
                        int propertyCount = helper.readVarInt(in);
                        ArrayList<GameProfile.Property> propertyList = new ArrayList<GameProfile.Property>();
                        for (int index = 0; index < propertyCount; ++index) {
                            propertyList.add(helper.readProperty(in));
                        }
                        profile.setProperties(propertyList);
                        entry.setProfile(profile);
                        break;
                    }
                    case INITIALIZE_CHAT: {
                        PublicKey publicKey;
                        if (!in.readBoolean()) break;
                        entry.setSessionId(helper.readUUID(in));
                        entry.setExpiresAt(in.readLong());
                        byte[] keyBytes = helper.readByteArray(in);
                        entry.setKeySignature(helper.readByteArray(in));
                        try {
                            publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
                        }
                        catch (GeneralSecurityException e) {
                            throw new IOException("Could not decode public key.", e);
                        }
                        entry.setPublicKey(publicKey);
                        break;
                    }
                    case UPDATE_GAME_MODE: {
                        GameMode gameMode = GameMode.byId(helper.readVarInt(in));
                        entry.setGameMode(gameMode);
                        break;
                    }
                    case UPDATE_LISTED: {
                        boolean listed = in.readBoolean();
                        entry.setListed(listed);
                        break;
                    }
                    case UPDATE_LATENCY: {
                        int latency = helper.readVarInt(in);
                        entry.setLatency(latency);
                        break;
                    }
                    case UPDATE_DISPLAY_NAME: {
                        Component displayName = helper.readNullable(in, helper::readComponent);
                        entry.setDisplayName(displayName);
                        break;
                    }
                }
            }
            this.entries[count] = entry;
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeEnumSet(out, this.actions, PlayerListEntryAction.VALUES);
        helper.writeVarInt(out, this.entries.length);
        for (PlayerListEntry entry : this.entries) {
            helper.writeUUID(out, entry.getProfile().getId());
            block9: for (PlayerListEntryAction action : this.actions) {
                switch (action) {
                    case ADD_PLAYER: {
                        helper.writeString(out, entry.getProfile().getName());
                        helper.writeVarInt(out, entry.getProfile().getProperties().size());
                        for (GameProfile.Property property : entry.getProfile().getProperties()) {
                            helper.writeProperty(out, property);
                        }
                        continue block9;
                    }
                    case INITIALIZE_CHAT: {
                        out.writeBoolean(entry.getPublicKey() != null);
                        if (entry.getPublicKey() == null) break;
                        helper.writeUUID(out, entry.getSessionId());
                        out.writeLong(entry.getExpiresAt());
                        helper.writeByteArray(out, entry.getPublicKey().getEncoded());
                        helper.writeByteArray(out, entry.getKeySignature());
                        break;
                    }
                    case UPDATE_GAME_MODE: {
                        helper.writeVarInt(out, entry.getGameMode().ordinal());
                        break;
                    }
                    case UPDATE_LISTED: {
                        out.writeBoolean(entry.isListed());
                        break;
                    }
                    case UPDATE_LATENCY: {
                        helper.writeVarInt(out, entry.getLatency());
                        break;
                    }
                    case UPDATE_DISPLAY_NAME: {
                        helper.writeNullable(out, entry.getDisplayName(), helper::writeComponent);
                    }
                }
            }
        }
    }

    public EnumSet<PlayerListEntryAction> getActions() {
        return this.actions;
    }

    public PlayerListEntry[] getEntries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerInfoUpdatePacket)) {
            return false;
        }
        ClientboundPlayerInfoUpdatePacket other = (ClientboundPlayerInfoUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EnumSet<PlayerListEntryAction> this$actions = this.getActions();
        EnumSet<PlayerListEntryAction> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        return Arrays.deepEquals(this.getEntries(), other.getEntries());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerInfoUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnumSet<PlayerListEntryAction> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEntries());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerInfoUpdatePacket(actions=" + this.getActions() + ", entries=" + Arrays.deepToString(this.getEntries()) + ")";
    }

    public ClientboundPlayerInfoUpdatePacket withActions(EnumSet<PlayerListEntryAction> actions) {
        return this.actions == actions ? this : new ClientboundPlayerInfoUpdatePacket(actions, this.entries);
    }

    public ClientboundPlayerInfoUpdatePacket withEntries(PlayerListEntry[] entries) {
        return this.entries == entries ? this : new ClientboundPlayerInfoUpdatePacket(this.actions, entries);
    }

    public ClientboundPlayerInfoUpdatePacket(EnumSet<PlayerListEntryAction> actions, PlayerListEntry[] entries) {
        this.actions = actions;
        this.entries = entries;
    }
}

