/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClientboundDisguisedChatPacket
implements MinecraftPacket {
    private final Component message;
    private final int chatType;
    private final Component name;
    @Nullable
    private final Component targetName;

    public ClientboundDisguisedChatPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.message = helper.readComponent(in);
        this.chatType = helper.readVarInt(in);
        this.name = helper.readComponent(in);
        this.targetName = helper.readNullable(in, helper::readComponent);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeComponent(out, this.message);
        helper.writeVarInt(out, this.chatType);
        helper.writeComponent(out, this.name);
        helper.writeNullable(out, this.targetName, helper::writeComponent);
    }

    public Component getMessage() {
        return this.message;
    }

    public int getChatType() {
        return this.chatType;
    }

    public Component getName() {
        return this.name;
    }

    @Nullable
    public Component getTargetName() {
        return this.targetName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundDisguisedChatPacket)) {
            return false;
        }
        ClientboundDisguisedChatPacket other = (ClientboundDisguisedChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChatType() != other.getChatType()) {
            return false;
        }
        Component this$message = this.getMessage();
        Component other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Component this$name = this.getName();
        Component other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Component this$targetName = this.getTargetName();
        Component other$targetName = other.getTargetName();
        return !(this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundDisguisedChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChatType();
        Component $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Component $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Component $targetName = this.getTargetName();
        result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundDisguisedChatPacket(message=" + this.getMessage() + ", chatType=" + this.getChatType() + ", name=" + this.getName() + ", targetName=" + this.getTargetName() + ")";
    }

    public ClientboundDisguisedChatPacket withMessage(Component message) {
        return this.message == message ? this : new ClientboundDisguisedChatPacket(message, this.chatType, this.name, this.targetName);
    }

    public ClientboundDisguisedChatPacket withChatType(int chatType) {
        return this.chatType == chatType ? this : new ClientboundDisguisedChatPacket(this.message, chatType, this.name, this.targetName);
    }

    public ClientboundDisguisedChatPacket withName(Component name) {
        return this.name == name ? this : new ClientboundDisguisedChatPacket(this.message, this.chatType, name, this.targetName);
    }

    public ClientboundDisguisedChatPacket withTargetName(@Nullable Component targetName) {
        return this.targetName == targetName ? this : new ClientboundDisguisedChatPacket(this.message, this.chatType, this.name, targetName);
    }

    public ClientboundDisguisedChatPacket(Component message, int chatType, Component name, @Nullable Component targetName) {
        this.message = message;
        this.chatType = chatType;
        this.name = name;
        this.targetName = targetName;
    }
}

