/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.common.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ServerboundKeepAlivePacket
implements MinecraftPacket {
    private final long pingId;

    public ServerboundKeepAlivePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.pingId = in.readLong();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeLong(this.pingId);
    }

    public long getPingId() {
        return this.pingId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundKeepAlivePacket)) {
            return false;
        }
        ServerboundKeepAlivePacket other = (ServerboundKeepAlivePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getPingId() == other.getPingId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundKeepAlivePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pingId = this.getPingId();
        result = result * 59 + (int)($pingId >>> 32 ^ $pingId);
        return result;
    }

    public String toString() {
        return "ServerboundKeepAlivePacket(pingId=" + this.getPingId() + ")";
    }

    public ServerboundKeepAlivePacket withPingId(long pingId) {
        return this.pingId == pingId ? this : new ServerboundKeepAlivePacket(pingId);
    }

    public ServerboundKeepAlivePacket(long pingId) {
        this.pingId = pingId;
    }
}

