/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ServerboundHelloPacket
implements MinecraftPacket {
    @NonNull
    private final String username;
    @Nullable
    private final UUID profileId;

    public ServerboundHelloPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.username = helper.readString(in);
        this.profileId = helper.readNullable(in, helper::readUUID);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeString(out, this.username);
        helper.writeNullable(out, this.profileId, helper::writeUUID);
    }

    @Override
    public boolean isPriority() {
        return true;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public UUID getProfileId() {
        return this.profileId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundHelloPacket)) {
            return false;
        }
        ServerboundHelloPacket other = (ServerboundHelloPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        UUID this$profileId = this.getProfileId();
        UUID other$profileId = other.getProfileId();
        return !(this$profileId == null ? other$profileId != null : !((Object)this$profileId).equals(other$profileId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundHelloPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        UUID $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : ((Object)$profileId).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundHelloPacket(username=" + this.getUsername() + ", profileId=" + this.getProfileId() + ")";
    }

    public ServerboundHelloPacket withUsername(@NonNull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        return this.username == username ? this : new ServerboundHelloPacket(username, this.profileId);
    }

    public ServerboundHelloPacket withProfileId(@Nullable UUID profileId) {
        return this.profileId == profileId ? this : new ServerboundHelloPacket(this.username, profileId);
    }

    public ServerboundHelloPacket(@NonNull String username, @Nullable UUID profileId) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.username = username;
        this.profileId = profileId;
    }
}

