/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.scoreboard;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ObjectiveAction;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreType;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ClientboundSetObjectivePacket
implements MinecraftPacket {
    @NonNull
    private final String name;
    @NonNull
    private final ObjectiveAction action;
    private final Component displayName;
    private final ScoreType type;

    public ClientboundSetObjectivePacket(@NonNull String name) {
        this(name, ObjectiveAction.REMOVE, null, null);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public ClientboundSetObjectivePacket(@NonNull String name, @NonNull ObjectiveAction action, Component displayName, ScoreType type) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (!(action != ObjectiveAction.ADD && action != ObjectiveAction.UPDATE || displayName != null && type != null)) {
            throw new IllegalArgumentException("ADD and UPDATE actions require display name and type.");
        }
        this.name = name;
        this.action = action;
        this.displayName = displayName;
        this.type = type;
    }

    public ClientboundSetObjectivePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.name = helper.readString(in);
        this.action = ObjectiveAction.from(in.readByte());
        if (this.action == ObjectiveAction.ADD || this.action == ObjectiveAction.UPDATE) {
            this.displayName = helper.readComponent(in);
            this.type = ScoreType.from(helper.readVarInt(in));
        } else {
            this.displayName = null;
            this.type = null;
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.name);
        out.writeByte(this.action.ordinal());
        if (this.action == ObjectiveAction.ADD || this.action == ObjectiveAction.UPDATE) {
            helper.writeComponent(out, this.displayName);
            helper.writeVarInt(out, this.type.ordinal());
        }
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public ObjectiveAction getAction() {
        return this.action;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public ScoreType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetObjectivePacket)) {
            return false;
        }
        ClientboundSetObjectivePacket other = (ClientboundSetObjectivePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ObjectiveAction this$action = this.getAction();
        ObjectiveAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Component this$displayName = this.getDisplayName();
        Component other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        ScoreType this$type = this.getType();
        ScoreType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetObjectivePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ObjectiveAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Component $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        ScoreType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundSetObjectivePacket(name=" + this.getName() + ", action=" + (Object)((Object)this.getAction()) + ", displayName=" + this.getDisplayName() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public ClientboundSetObjectivePacket withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ClientboundSetObjectivePacket(name, this.action, this.displayName, this.type);
    }

    public ClientboundSetObjectivePacket withAction(@NonNull ObjectiveAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientboundSetObjectivePacket(this.name, action, this.displayName, this.type);
    }

    public ClientboundSetObjectivePacket withDisplayName(Component displayName) {
        return this.displayName == displayName ? this : new ClientboundSetObjectivePacket(this.name, this.action, displayName, this.type);
    }

    public ClientboundSetObjectivePacket withType(ScoreType type) {
        return this.type == type ? this : new ClientboundSetObjectivePacket(this.name, this.action, this.displayName, type);
    }
}

