/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.level.sound.SoundCategory;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class ClientboundStopSoundPacket
implements MinecraftPacket {
    private static final int FLAG_CATEGORY = 1;
    private static final int FLAG_SOUND = 2;
    @Nullable
    private final SoundCategory category;
    @Nullable
    private final String sound;

    public ClientboundStopSoundPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        byte flags = in.readByte();
        this.category = (flags & 1) != 0 ? helper.readSoundCategory(in) : null;
        this.sound = (flags & 2) != 0 ? helper.readResourceLocation(in) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        int flags = 0;
        if (this.category != null) {
            flags |= 1;
        }
        if (this.sound != null) {
            flags |= 2;
        }
        out.writeByte(flags);
        if (this.category != null) {
            out.writeByte(this.category.ordinal());
        }
        if (this.sound != null) {
            helper.writeResourceLocation(out, this.sound);
        }
    }

    @Nullable
    public SoundCategory getCategory() {
        return this.category;
    }

    @Nullable
    public String getSound() {
        return this.sound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundStopSoundPacket)) {
            return false;
        }
        ClientboundStopSoundPacket other = (ClientboundStopSoundPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SoundCategory this$category = this.getCategory();
        SoundCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        String this$sound = this.getSound();
        String other$sound = other.getSound();
        return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundStopSoundPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SoundCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        String $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundStopSoundPacket(category=" + (Object)((Object)this.getCategory()) + ", sound=" + this.getSound() + ")";
    }

    public ClientboundStopSoundPacket withCategory(@Nullable SoundCategory category) {
        return this.category == category ? this : new ClientboundStopSoundPacket(category, this.sound);
    }

    public ClientboundStopSoundPacket withSound(@Nullable String sound) {
        return this.sound == sound ? this : new ClientboundStopSoundPacket(this.category, sound);
    }

    public ClientboundStopSoundPacket(@Nullable SoundCategory category, @Nullable String sound) {
        this.category = category;
        this.sound = sound;
    }
}

