/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ServerboundHelloPacket
implements MinecraftPacket {
    @NonNull
    private final String username;
    @Nullable
    private final Long expiresAt;
    @Nullable
    private final PublicKey publicKey;
    @Nullable
    private final byte[] keySignature;

    public ServerboundHelloPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.username = helper.readString(in);
        if (in.readBoolean()) {
            this.expiresAt = in.readLong();
            byte[] publicKey = helper.readByteArray(in);
            this.keySignature = helper.readByteArray(in);
            try {
                this.publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Could not decode public key.", e);
            }
        } else {
            this.expiresAt = null;
            this.publicKey = null;
            this.keySignature = null;
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.username);
        out.writeBoolean(this.publicKey != null);
        if (this.publicKey != null) {
            out.writeLong(this.expiresAt.longValue());
            byte[] encoded = this.publicKey.getEncoded();
            helper.writeByteArray(out, encoded);
            helper.writeByteArray(out, this.keySignature);
        }
    }

    public boolean isPriority() {
        return true;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Nullable
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Nullable
    public byte[] getKeySignature() {
        return this.keySignature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundHelloPacket)) {
            return false;
        }
        ServerboundHelloPacket other = (ServerboundHelloPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        return Arrays.equals(this.getKeySignature(), other.getKeySignature());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundHelloPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeySignature());
        return result;
    }

    public String toString() {
        return "ServerboundHelloPacket(username=" + this.getUsername() + ", expiresAt=" + this.getExpiresAt() + ", publicKey=" + this.getPublicKey() + ", keySignature=" + Arrays.toString(this.getKeySignature()) + ")";
    }

    public ServerboundHelloPacket withUsername(@NonNull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        return this.username == username ? this : new ServerboundHelloPacket(username, this.expiresAt, this.publicKey, this.keySignature);
    }

    public ServerboundHelloPacket withExpiresAt(@Nullable Long expiresAt) {
        return this.expiresAt == expiresAt ? this : new ServerboundHelloPacket(this.username, expiresAt, this.publicKey, this.keySignature);
    }

    public ServerboundHelloPacket withPublicKey(@Nullable PublicKey publicKey) {
        return this.publicKey == publicKey ? this : new ServerboundHelloPacket(this.username, this.expiresAt, publicKey, this.keySignature);
    }

    public ServerboundHelloPacket withKeySignature(@Nullable byte[] keySignature) {
        return this.keySignature == keySignature ? this : new ServerboundHelloPacket(this.username, this.expiresAt, this.publicKey, keySignature);
    }

    public ServerboundHelloPacket(@NonNull String username, @Nullable Long expiresAt, @Nullable PublicKey publicKey, @Nullable byte[] keySignature) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.username = username;
        this.expiresAt = expiresAt;
        this.publicKey = publicKey;
        this.keySignature = keySignature;
    }
}

