/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.clientbound;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import lombok.NonNull;

public class ClientboundGameProfilePacket
implements MinecraftPacket {
    @NonNull
    private final GameProfile profile;

    public ClientboundGameProfilePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        GameProfile profile = new GameProfile(helper.readUUID(in), helper.readString(in));
        int properties = helper.readVarInt(in);
        ArrayList<GameProfile.Property> propertyList = new ArrayList<GameProfile.Property>();
        for (int index = 0; index < properties; ++index) {
            String propertyName = helper.readString(in);
            String value = helper.readString(in);
            String signature = null;
            if (in.readBoolean()) {
                signature = helper.readString(in);
            }
            propertyList.add(new GameProfile.Property(propertyName, value, signature));
        }
        profile.setProperties(propertyList);
        this.profile = profile;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeUUID(out, this.profile.getId());
        helper.writeString(out, this.profile.getName());
        helper.writeVarInt(out, this.profile.getProperties().size());
        for (GameProfile.Property property : this.profile.getProperties()) {
            helper.writeString(out, property.getName());
            helper.writeString(out, property.getValue());
            out.writeBoolean(property.hasSignature());
            if (!property.hasSignature()) continue;
            helper.writeString(out, property.getSignature());
        }
    }

    public boolean isPriority() {
        return true;
    }

    @NonNull
    public GameProfile getProfile() {
        return this.profile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundGameProfilePacket)) {
            return false;
        }
        ClientboundGameProfilePacket other = (ClientboundGameProfilePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GameProfile this$profile = this.getProfile();
        GameProfile other$profile = other.getProfile();
        return !(this$profile == null ? other$profile != null : !this$profile.equals(other$profile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundGameProfilePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GameProfile $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundGameProfilePacket(profile=" + this.getProfile() + ")";
    }

    public ClientboundGameProfilePacket withProfile(@NonNull GameProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        return this.profile == profile ? this : new ClientboundGameProfilePacket(profile);
    }

    public ClientboundGameProfilePacket(@NonNull GameProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        this.profile = profile;
    }
}

