/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundUseItemOnPacket
implements MinecraftPacket {
    @NonNull
    private final Vector3i position;
    @NonNull
    private final Direction face;
    @NonNull
    private final Hand hand;
    private final float cursorX;
    private final float cursorY;
    private final float cursorZ;
    private final boolean insideBlock;
    private final int sequence;

    public ServerboundUseItemOnPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.hand = MagicValues.key(Hand.class, helper.readVarInt(in));
        this.position = helper.readPosition(in);
        this.face = helper.readDirection(in);
        this.cursorX = in.readFloat();
        this.cursorY = in.readFloat();
        this.cursorZ = in.readFloat();
        this.insideBlock = in.readBoolean();
        this.sequence = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, MagicValues.value(Integer.class, (Object)this.hand));
        helper.writePosition(out, this.position);
        helper.writeDirection(out, this.face);
        out.writeFloat(this.cursorX);
        out.writeFloat(this.cursorY);
        out.writeFloat(this.cursorZ);
        out.writeBoolean(this.insideBlock);
        helper.writeVarInt(out, this.sequence);
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @NonNull
    public Direction getFace() {
        return this.face;
    }

    @NonNull
    public Hand getHand() {
        return this.hand;
    }

    public float getCursorX() {
        return this.cursorX;
    }

    public float getCursorY() {
        return this.cursorY;
    }

    public float getCursorZ() {
        return this.cursorZ;
    }

    public boolean isInsideBlock() {
        return this.insideBlock;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundUseItemOnPacket)) {
            return false;
        }
        ServerboundUseItemOnPacket other = (ServerboundUseItemOnPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getCursorX(), other.getCursorX()) != 0) {
            return false;
        }
        if (Float.compare(this.getCursorY(), other.getCursorY()) != 0) {
            return false;
        }
        if (Float.compare(this.getCursorZ(), other.getCursorZ()) != 0) {
            return false;
        }
        if (this.isInsideBlock() != other.isInsideBlock()) {
            return false;
        }
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Direction this$face = this.getFace();
        Direction other$face = other.getFace();
        if (this$face == null ? other$face != null : !this$face.equals(other$face)) {
            return false;
        }
        Hand this$hand = this.getHand();
        Hand other$hand = other.getHand();
        return !(this$hand == null ? other$hand != null : !((Object)((Object)this$hand)).equals((Object)other$hand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundUseItemOnPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getCursorX());
        result = result * 59 + Float.floatToIntBits(this.getCursorY());
        result = result * 59 + Float.floatToIntBits(this.getCursorZ());
        result = result * 59 + (this.isInsideBlock() ? 79 : 97);
        result = result * 59 + this.getSequence();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Direction $face = this.getFace();
        result = result * 59 + ($face == null ? 43 : $face.hashCode());
        Hand $hand = this.getHand();
        result = result * 59 + ($hand == null ? 43 : ((Object)((Object)$hand)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundUseItemOnPacket(position=" + this.getPosition() + ", face=" + this.getFace() + ", hand=" + (Object)((Object)this.getHand()) + ", cursorX=" + this.getCursorX() + ", cursorY=" + this.getCursorY() + ", cursorZ=" + this.getCursorZ() + ", insideBlock=" + this.isInsideBlock() + ", sequence=" + this.getSequence() + ")";
    }

    public ServerboundUseItemOnPacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundUseItemOnPacket(position, this.face, this.hand, this.cursorX, this.cursorY, this.cursorZ, this.insideBlock, this.sequence);
    }

    public ServerboundUseItemOnPacket withFace(@NonNull Direction face) {
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        return this.face == face ? this : new ServerboundUseItemOnPacket(this.position, face, this.hand, this.cursorX, this.cursorY, this.cursorZ, this.insideBlock, this.sequence);
    }

    public ServerboundUseItemOnPacket withHand(@NonNull Hand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        return this.hand == hand ? this : new ServerboundUseItemOnPacket(this.position, this.face, hand, this.cursorX, this.cursorY, this.cursorZ, this.insideBlock, this.sequence);
    }

    public ServerboundUseItemOnPacket withCursorX(float cursorX) {
        return this.cursorX == cursorX ? this : new ServerboundUseItemOnPacket(this.position, this.face, this.hand, cursorX, this.cursorY, this.cursorZ, this.insideBlock, this.sequence);
    }

    public ServerboundUseItemOnPacket withCursorY(float cursorY) {
        return this.cursorY == cursorY ? this : new ServerboundUseItemOnPacket(this.position, this.face, this.hand, this.cursorX, cursorY, this.cursorZ, this.insideBlock, this.sequence);
    }

    public ServerboundUseItemOnPacket withCursorZ(float cursorZ) {
        return this.cursorZ == cursorZ ? this : new ServerboundUseItemOnPacket(this.position, this.face, this.hand, this.cursorX, this.cursorY, cursorZ, this.insideBlock, this.sequence);
    }

    public ServerboundUseItemOnPacket withInsideBlock(boolean insideBlock) {
        return this.insideBlock == insideBlock ? this : new ServerboundUseItemOnPacket(this.position, this.face, this.hand, this.cursorX, this.cursorY, this.cursorZ, insideBlock, this.sequence);
    }

    public ServerboundUseItemOnPacket withSequence(int sequence) {
        return this.sequence == sequence ? this : new ServerboundUseItemOnPacket(this.position, this.face, this.hand, this.cursorX, this.cursorY, this.cursorZ, this.insideBlock, sequence);
    }

    public ServerboundUseItemOnPacket(@NonNull Vector3i position, @NonNull Direction face, @NonNull Hand hand, float cursorX, float cursorY, float cursorZ, boolean insideBlock, int sequence) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        this.position = position;
        this.face = face;
        this.hand = hand;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
        this.cursorZ = cursorZ;
        this.insideBlock = insideBlock;
        this.sequence = sequence;
    }
}

