/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerAction;
import com.nukkitx.math.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundPlayerActionPacket
implements MinecraftPacket {
    @NonNull
    private final PlayerAction action;
    @NonNull
    private final Vector3i position;
    @NonNull
    private final Direction face;
    private final int sequence;

    public ServerboundPlayerActionPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.action = MagicValues.key(PlayerAction.class, helper.readVarInt(in));
        this.position = helper.readPosition(in);
        this.face = Direction.VALUES[in.readUnsignedByte()];
        this.sequence = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, MagicValues.value(Integer.class, (Object)this.action));
        helper.writePosition(out, this.position);
        out.writeByte(this.face.ordinal());
        helper.writeVarInt(out, this.sequence);
    }

    @NonNull
    public PlayerAction getAction() {
        return this.action;
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @NonNull
    public Direction getFace() {
        return this.face;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlayerActionPacket)) {
            return false;
        }
        ServerboundPlayerActionPacket other = (ServerboundPlayerActionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        PlayerAction this$action = this.getAction();
        PlayerAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Direction this$face = this.getFace();
        Direction other$face = other.getFace();
        return !(this$face == null ? other$face != null : !this$face.equals(other$face));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundPlayerActionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        PlayerAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Direction $face = this.getFace();
        result = result * 59 + ($face == null ? 43 : $face.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundPlayerActionPacket(action=" + (Object)((Object)this.getAction()) + ", position=" + this.getPosition() + ", face=" + this.getFace() + ", sequence=" + this.getSequence() + ")";
    }

    public ServerboundPlayerActionPacket withAction(@NonNull PlayerAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerboundPlayerActionPacket(action, this.position, this.face, this.sequence);
    }

    public ServerboundPlayerActionPacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundPlayerActionPacket(this.action, position, this.face, this.sequence);
    }

    public ServerboundPlayerActionPacket withFace(@NonNull Direction face) {
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        return this.face == face ? this : new ServerboundPlayerActionPacket(this.action, this.position, face, this.sequence);
    }

    public ServerboundPlayerActionPacket withSequence(int sequence) {
        return this.sequence == sequence ? this : new ServerboundPlayerActionPacket(this.action, this.position, this.face, sequence);
    }

    public ServerboundPlayerActionPacket(@NonNull PlayerAction action, @NonNull Vector3i position, @NonNull Direction face, int sequence) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        this.action = action;
        this.position = position;
        this.face = face;
        this.sequence = sequence;
    }
}

