/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.nukkitx.math.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ServerboundSignUpdatePacket
implements MinecraftPacket {
    @NonNull
    private final Vector3i position;
    @NonNull
    private final String[] lines;

    public ServerboundSignUpdatePacket(@NonNull Vector3i position, @NonNull String[] lines) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.length != 4) {
            throw new IllegalArgumentException("Lines must contain exactly 4 strings.");
        }
        this.position = position;
        this.lines = Arrays.copyOf(lines, lines.length);
    }

    public ServerboundSignUpdatePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.position = helper.readPosition(in);
        this.lines = new String[4];
        for (int count = 0; count < this.lines.length; ++count) {
            this.lines[count] = helper.readString(in);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writePosition(out, this.position);
        for (String line : this.lines) {
            helper.writeString(out, line);
        }
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @NonNull
    public String[] getLines() {
        return this.lines;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSignUpdatePacket)) {
            return false;
        }
        ServerboundSignUpdatePacket other = (ServerboundSignUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        return Arrays.deepEquals(this.getLines(), other.getLines());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundSignUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLines());
        return result;
    }

    public String toString() {
        return "ServerboundSignUpdatePacket(position=" + this.getPosition() + ", lines=" + Arrays.deepToString(this.getLines()) + ")";
    }

    public ServerboundSignUpdatePacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundSignUpdatePacket(position, this.lines);
    }

    public ServerboundSignUpdatePacket withLines(@NonNull String[] lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        return this.lines == lines ? this : new ServerboundSignUpdatePacket(this.position, lines);
    }
}

