/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.nukkitx.math.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundBlockEntityTagQuery
implements MinecraftPacket {
    private final int transactionId;
    @NonNull
    private final Vector3i position;

    public ServerboundBlockEntityTagQuery(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.transactionId = helper.readVarInt(in);
        this.position = helper.readPosition(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.transactionId);
        helper.writePosition(out, this.position);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundBlockEntityTagQuery)) {
            return false;
        }
        ServerboundBlockEntityTagQuery other = (ServerboundBlockEntityTagQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !this$position.equals(other$position));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundBlockEntityTagQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundBlockEntityTagQuery(transactionId=" + this.getTransactionId() + ", position=" + this.getPosition() + ")";
    }

    public ServerboundBlockEntityTagQuery withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ServerboundBlockEntityTagQuery(transactionId, this.position);
    }

    public ServerboundBlockEntityTagQuery withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundBlockEntityTagQuery(this.transactionId, position);
    }

    public ServerboundBlockEntityTagQuery(int transactionId, @NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.transactionId = transactionId;
        this.position = position;
    }
}

