/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ServerboundChatCommandPacket
implements MinecraftPacket {
    private final String command;
    private final long timeStamp;
    private final long salt;
    private final Map<String, byte[]> signatures;
    private final boolean signedPreview;

    public ServerboundChatCommandPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.command = helper.readString(in);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.signatures = new HashMap<String, byte[]>();
        int signatureCount = helper.readVarInt(in);
        for (int i = 0; i < signatureCount; ++i) {
            String signatureId = helper.readString(in);
            byte[] signature = helper.readByteArray(in);
            this.signatures.put(signatureId, signature);
        }
        this.signedPreview = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.command);
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        helper.writeVarInt(out, this.signatures.size());
        for (Map.Entry<String, byte[]> signature : this.signatures.entrySet()) {
            helper.writeString(out, signature.getKey());
            helper.writeVarInt(out, signature.getValue().length);
            out.writeBytes(signature.getValue());
        }
        out.writeBoolean(this.signedPreview);
    }

    public String getCommand() {
        return this.command;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public Map<String, byte[]> getSignatures() {
        return this.signatures;
    }

    public boolean isSignedPreview() {
        return this.signedPreview;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatCommandPacket)) {
            return false;
        }
        ServerboundChatCommandPacket other = (ServerboundChatCommandPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.isSignedPreview() != other.isSignedPreview()) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        Map<String, byte[]> this$signatures = this.getSignatures();
        Map<String, byte[]> other$signatures = other.getSignatures();
        return !(this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundChatCommandPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + (this.isSignedPreview() ? 79 : 97);
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        Map<String, byte[]> $signatures = this.getSignatures();
        result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundChatCommandPacket(command=" + this.getCommand() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", signatures=" + this.getSignatures() + ", signedPreview=" + this.isSignedPreview() + ")";
    }

    public ServerboundChatCommandPacket withCommand(String command) {
        return this.command == command ? this : new ServerboundChatCommandPacket(command, this.timeStamp, this.salt, this.signatures, this.signedPreview);
    }

    public ServerboundChatCommandPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ServerboundChatCommandPacket(this.command, timeStamp, this.salt, this.signatures, this.signedPreview);
    }

    public ServerboundChatCommandPacket withSalt(long salt) {
        return this.salt == salt ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, salt, this.signatures, this.signedPreview);
    }

    public ServerboundChatCommandPacket withSignatures(Map<String, byte[]> signatures) {
        return this.signatures == signatures ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, this.salt, signatures, this.signedPreview);
    }

    public ServerboundChatCommandPacket withSignedPreview(boolean signedPreview) {
        return this.signedPreview == signedPreview ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, this.salt, this.signatures, signedPreview);
    }

    public ServerboundChatCommandPacket(String command, long timeStamp, long salt, Map<String, byte[]> signatures, boolean signedPreview) {
        this.command = command;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.signatures = signatures;
        this.signedPreview = signedPreview;
    }
}

