/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.scoreboard;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreboardPosition;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundSetDisplayObjectivePacket
implements MinecraftPacket {
    @NonNull
    private final ScoreboardPosition position;
    @NonNull
    private final String name;

    public ClientboundSetDisplayObjectivePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.position = MagicValues.key(ScoreboardPosition.class, in.readByte());
        this.name = helper.readString(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeByte(MagicValues.value(Integer.class, (Object)this.position).intValue());
        helper.writeString(out, this.name);
    }

    @NonNull
    public ScoreboardPosition getPosition() {
        return this.position;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetDisplayObjectivePacket)) {
            return false;
        }
        ClientboundSetDisplayObjectivePacket other = (ClientboundSetDisplayObjectivePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScoreboardPosition this$position = this.getPosition();
        ScoreboardPosition other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)((Object)this$position)).equals((Object)other$position)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetDisplayObjectivePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScoreboardPosition $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)((Object)$position)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundSetDisplayObjectivePacket(position=" + (Object)((Object)this.getPosition()) + ", name=" + this.getName() + ")";
    }

    public ClientboundSetDisplayObjectivePacket withPosition(@NonNull ScoreboardPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundSetDisplayObjectivePacket(position, this.name);
    }

    public ClientboundSetDisplayObjectivePacket withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ClientboundSetDisplayObjectivePacket(this.position, name);
    }

    public ClientboundSetDisplayObjectivePacket(@NonNull ScoreboardPosition position, @NonNull String name) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.position = position;
        this.name = name;
    }
}

