/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.level.LightUpdateData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class ClientboundLightUpdatePacket
implements MinecraftPacket {
    private final int x;
    private final int z;
    @NotNull
    private final LightUpdateData lightData;

    public ClientboundLightUpdatePacket(int x, int z, @NonNull BitSet skyYMask, @NonNull BitSet blockYMask, @NonNull BitSet emptySkyYMask, @NonNull BitSet emptyBlockYMask, @NonNull List<byte[]> skyUpdates, @NonNull List<byte[]> blockUpdates, boolean trustEdges) {
        if (skyYMask == null) {
            throw new NullPointerException("skyYMask is marked non-null but is null");
        }
        if (blockYMask == null) {
            throw new NullPointerException("blockYMask is marked non-null but is null");
        }
        if (emptySkyYMask == null) {
            throw new NullPointerException("emptySkyYMask is marked non-null but is null");
        }
        if (emptyBlockYMask == null) {
            throw new NullPointerException("emptyBlockYMask is marked non-null but is null");
        }
        if (skyUpdates == null) {
            throw new NullPointerException("skyUpdates is marked non-null but is null");
        }
        if (blockUpdates == null) {
            throw new NullPointerException("blockUpdates is marked non-null but is null");
        }
        for (byte[] content : skyUpdates) {
            if (content.length == 2048) continue;
            throw new IllegalArgumentException("All arrays in skyUpdates must be length of 2048!");
        }
        for (byte[] content : blockUpdates) {
            if (content.length == 2048) continue;
            throw new IllegalArgumentException("All arrays in blockUpdates must be length of 2048!");
        }
        this.x = x;
        this.z = z;
        this.lightData = new LightUpdateData(skyYMask, blockYMask, emptySkyYMask, emptyBlockYMask, skyUpdates, blockUpdates, trustEdges);
    }

    public ClientboundLightUpdatePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.x = helper.readVarInt(in);
        this.z = helper.readVarInt(in);
        this.lightData = helper.readLightUpdateData(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.x);
        helper.writeVarInt(out, this.z);
        helper.writeLightUpdateData(out, this.lightData);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @NotNull
    public LightUpdateData getLightData() {
        return this.lightData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLightUpdatePacket)) {
            return false;
        }
        ClientboundLightUpdatePacket other = (ClientboundLightUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        LightUpdateData this$lightData = this.getLightData();
        LightUpdateData other$lightData = other.getLightData();
        return !(this$lightData == null ? other$lightData != null : !((Object)this$lightData).equals(other$lightData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundLightUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        LightUpdateData $lightData = this.getLightData();
        result = result * 59 + ($lightData == null ? 43 : ((Object)$lightData).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundLightUpdatePacket(x=" + this.getX() + ", z=" + this.getZ() + ", lightData=" + this.getLightData() + ")";
    }

    public ClientboundLightUpdatePacket withX(int x) {
        return this.x == x ? this : new ClientboundLightUpdatePacket(x, this.z, this.lightData);
    }

    public ClientboundLightUpdatePacket withZ(int z) {
        return this.z == z ? this : new ClientboundLightUpdatePacket(this.x, z, this.lightData);
    }

    public ClientboundLightUpdatePacket withLightData(@NotNull LightUpdateData lightData) {
        if (lightData == null) {
            throw new NullPointerException("lightData is marked non-null but is null");
        }
        return this.lightData == lightData ? this : new ClientboundLightUpdatePacket(this.x, this.z, lightData);
    }

    public ClientboundLightUpdatePacket(int x, int z, @NotNull LightUpdateData lightData) {
        if (lightData == null) {
            throw new NullPointerException("lightData is marked non-null but is null");
        }
        this.x = x;
        this.z = z;
        this.lightData = lightData;
    }
}

