/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.level.event.BonemealGrowEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.BreakBlockEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.BreakPotionEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.ComposterEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.DragonFireballEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.LevelEvent;
import com.github.steveice10.mc.protocol.data.game.level.event.LevelEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.RecordEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.SculkBlockChargeEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.SmokeEventData;
import com.nukkitx.math.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundLevelEventPacket
implements MinecraftPacket {
    @NonNull
    private final LevelEvent event;
    @NonNull
    private final Vector3i position;
    private final LevelEventData data;
    private final boolean broadcast;

    public ClientboundLevelEventPacket(@NonNull LevelEvent event, @NonNull Vector3i position, @NonNull LevelEventData data) {
        this(event, position, data, false);
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
    }

    public ClientboundLevelEventPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.event = helper.readLevelEvent(in);
        this.position = helper.readPosition(in);
        int value = in.readInt();
        switch (this.event) {
            case RECORD: {
                this.data = new RecordEventData(value);
                break;
            }
            case SMOKE: {
                this.data = MagicValues.key(SmokeEventData.class, value % 6);
                break;
            }
            case BREAK_BLOCK: {
                this.data = new BreakBlockEventData(value);
                break;
            }
            case BREAK_SPLASH_POTION: 
            case BREAK_SPLASH_POTION2: {
                this.data = new BreakPotionEventData(value);
                break;
            }
            case BONEMEAL_GROW: 
            case BONEMEAL_GROW_WITH_SOUND: {
                this.data = new BonemealGrowEventData(value);
                break;
            }
            case COMPOSTER: {
                this.data = value > 0 ? ComposterEventData.FILL_SUCCESS : ComposterEventData.FILL;
                break;
            }
            case ENDERDRAGON_FIREBALL_EXPLODE: {
                this.data = value == 1 ? DragonFireballEventData.HAS_SOUND : DragonFireballEventData.NO_SOUND;
                break;
            }
            case SCULK_BLOCK_CHARGE: {
                this.data = new SculkBlockChargeEventData(value);
                break;
            }
            default: {
                this.data = null;
            }
        }
        this.broadcast = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeLevelEvent(out, this.event);
        helper.writePosition(out, this.position);
        int value = 0;
        if (this.data instanceof RecordEventData) {
            value = ((RecordEventData)this.data).getRecordId();
        } else if (this.data instanceof SmokeEventData) {
            value = MagicValues.value(Integer.class, this.data);
        } else if (this.data instanceof BreakBlockEventData) {
            value = ((BreakBlockEventData)this.data).getBlockState();
        } else if (this.data instanceof BreakPotionEventData) {
            value = ((BreakPotionEventData)this.data).getPotionId();
        } else if (this.data instanceof BonemealGrowEventData) {
            value = ((BonemealGrowEventData)this.data).getParticleCount();
        } else if (this.data instanceof ComposterEventData) {
            value = MagicValues.value(Integer.class, this.data);
        } else if (this.data instanceof DragonFireballEventData) {
            value = MagicValues.value(Integer.class, this.data);
        } else if (this.data instanceof SculkBlockChargeEventData) {
            value = ((SculkBlockChargeEventData)this.data).getLevelValue();
        }
        out.writeInt(value);
        out.writeBoolean(this.broadcast);
    }

    @NonNull
    public LevelEvent getEvent() {
        return this.event;
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    public LevelEventData getData() {
        return this.data;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLevelEventPacket)) {
            return false;
        }
        ClientboundLevelEventPacket other = (ClientboundLevelEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBroadcast() != other.isBroadcast()) {
            return false;
        }
        LevelEvent this$event = this.getEvent();
        LevelEvent other$event = other.getEvent();
        if (this$event == null ? other$event != null : !((Object)((Object)this$event)).equals((Object)other$event)) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        LevelEventData this$data = this.getData();
        LevelEventData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundLevelEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBroadcast() ? 79 : 97);
        LevelEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)((Object)$event)).hashCode());
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        LevelEventData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundLevelEventPacket(event=" + (Object)((Object)this.getEvent()) + ", position=" + this.getPosition() + ", data=" + this.getData() + ", broadcast=" + this.isBroadcast() + ")";
    }

    public ClientboundLevelEventPacket withEvent(@NonNull LevelEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return this.event == event ? this : new ClientboundLevelEventPacket(event, this.position, this.data, this.broadcast);
    }

    public ClientboundLevelEventPacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundLevelEventPacket(this.event, position, this.data, this.broadcast);
    }

    public ClientboundLevelEventPacket withData(LevelEventData data) {
        return this.data == data ? this : new ClientboundLevelEventPacket(this.event, this.position, data, this.broadcast);
    }

    public ClientboundLevelEventPacket withBroadcast(boolean broadcast) {
        return this.broadcast == broadcast ? this : new ClientboundLevelEventPacket(this.event, this.position, this.data, broadcast);
    }

    public ClientboundLevelEventPacket(@NonNull LevelEvent event, @NonNull Vector3i position, LevelEventData data, boolean broadcast) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.event = event;
        this.position = position;
        this.data = data;
        this.broadcast = broadcast;
    }
}

