/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientboundTakeItemEntityPacket
implements MinecraftPacket {
    private final int collectedEntityId;
    private final int collectorEntityId;
    private final int itemCount;

    public ClientboundTakeItemEntityPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.collectedEntityId = helper.readVarInt(in);
        this.collectorEntityId = helper.readVarInt(in);
        this.itemCount = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.collectedEntityId);
        helper.writeVarInt(out, this.collectorEntityId);
        helper.writeVarInt(out, this.itemCount);
    }

    public int getCollectedEntityId() {
        return this.collectedEntityId;
    }

    public int getCollectorEntityId() {
        return this.collectorEntityId;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTakeItemEntityPacket)) {
            return false;
        }
        ClientboundTakeItemEntityPacket other = (ClientboundTakeItemEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCollectedEntityId() != other.getCollectedEntityId()) {
            return false;
        }
        if (this.getCollectorEntityId() != other.getCollectorEntityId()) {
            return false;
        }
        return this.getItemCount() == other.getItemCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundTakeItemEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCollectedEntityId();
        result = result * 59 + this.getCollectorEntityId();
        result = result * 59 + this.getItemCount();
        return result;
    }

    public String toString() {
        return "ClientboundTakeItemEntityPacket(collectedEntityId=" + this.getCollectedEntityId() + ", collectorEntityId=" + this.getCollectorEntityId() + ", itemCount=" + this.getItemCount() + ")";
    }

    public ClientboundTakeItemEntityPacket withCollectedEntityId(int collectedEntityId) {
        return this.collectedEntityId == collectedEntityId ? this : new ClientboundTakeItemEntityPacket(collectedEntityId, this.collectorEntityId, this.itemCount);
    }

    public ClientboundTakeItemEntityPacket withCollectorEntityId(int collectorEntityId) {
        return this.collectorEntityId == collectorEntityId ? this : new ClientboundTakeItemEntityPacket(this.collectedEntityId, collectorEntityId, this.itemCount);
    }

    public ClientboundTakeItemEntityPacket withItemCount(int itemCount) {
        return this.itemCount == itemCount ? this : new ClientboundTakeItemEntityPacket(this.collectedEntityId, this.collectorEntityId, itemCount);
    }

    public ClientboundTakeItemEntityPacket(int collectedEntityId, int collectorEntityId, int itemCount) {
        this.collectedEntityId = collectedEntityId;
        this.collectorEntityId = collectorEntityId;
        this.itemCount = itemCount;
    }
}

