/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.recipe.Ingredient;
import com.github.steveice10.mc.protocol.data.game.recipe.Recipe;
import com.github.steveice10.mc.protocol.data.game.recipe.RecipeType;
import com.github.steveice10.mc.protocol.data.game.recipe.data.CookedRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.RecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.ShapedRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.ShapelessRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.SmithingRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.StoneCuttingRecipeData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundUpdateRecipesPacket
implements MinecraftPacket {
    @NonNull
    private final Recipe[] recipes;

    public ClientboundUpdateRecipesPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.recipes = new Recipe[helper.readVarInt(in)];
        for (int i = 0; i < this.recipes.length; ++i) {
            RecipeType type = MagicValues.key(RecipeType.class, Identifier.formalize(helper.readString(in)));
            String identifier = helper.readString(in);
            RecipeData data = null;
            switch (type) {
                case CRAFTING_SHAPELESS: {
                    String group = helper.readString(in);
                    Ingredient[] ingredients = new Ingredient[helper.readVarInt(in)];
                    for (int j = 0; j < ingredients.length; ++j) {
                        ingredients[j] = helper.readRecipeIngredient(in);
                    }
                    ItemStack result = helper.readItemStack(in);
                    data = new ShapelessRecipeData(group, ingredients, result);
                    break;
                }
                case CRAFTING_SHAPED: {
                    int width = helper.readVarInt(in);
                    int height = helper.readVarInt(in);
                    String group = helper.readString(in);
                    Ingredient[] ingredients = new Ingredient[width * height];
                    for (int j = 0; j < ingredients.length; ++j) {
                        ingredients[j] = helper.readRecipeIngredient(in);
                    }
                    ItemStack result = helper.readItemStack(in);
                    data = new ShapedRecipeData(width, height, group, ingredients, result);
                    break;
                }
                case SMELTING: 
                case BLASTING: 
                case SMOKING: 
                case CAMPFIRE_COOKING: {
                    String group = helper.readString(in);
                    Ingredient ingredient = helper.readRecipeIngredient(in);
                    ItemStack result = helper.readItemStack(in);
                    float experience = in.readFloat();
                    int cookingTime = helper.readVarInt(in);
                    data = new CookedRecipeData(group, ingredient, result, experience, cookingTime);
                    break;
                }
                case STONECUTTING: {
                    String group = helper.readString(in);
                    Ingredient ingredient = helper.readRecipeIngredient(in);
                    ItemStack result = helper.readItemStack(in);
                    data = new StoneCuttingRecipeData(group, ingredient, result);
                    break;
                }
                case SMITHING: {
                    Ingredient base = helper.readRecipeIngredient(in);
                    Ingredient addition = helper.readRecipeIngredient(in);
                    ItemStack result = helper.readItemStack(in);
                    data = new SmithingRecipeData(base, addition, result);
                    break;
                }
            }
            this.recipes[i] = new Recipe(type, identifier, data);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.recipes.length);
        block7: for (Recipe recipe : this.recipes) {
            helper.writeString(out, MagicValues.value(String.class, (Object)recipe.getType()));
            helper.writeString(out, recipe.getIdentifier());
            switch (recipe.getType()) {
                case CRAFTING_SHAPELESS: {
                    RecipeData data = (ShapelessRecipeData)recipe.getData();
                    helper.writeString(out, ((ShapelessRecipeData)data).getGroup());
                    helper.writeVarInt(out, ((ShapelessRecipeData)data).getIngredients().length);
                    for (Ingredient ingredient : ((ShapelessRecipeData)data).getIngredients()) {
                        helper.writeRecipeIngredient(out, ingredient);
                    }
                    helper.writeItemStack(out, ((ShapelessRecipeData)data).getResult());
                    continue block7;
                }
                case CRAFTING_SHAPED: {
                    RecipeData data = (ShapedRecipeData)recipe.getData();
                    if (((ShapedRecipeData)data).getIngredients().length != ((ShapedRecipeData)data).getWidth() * ((ShapedRecipeData)data).getHeight()) {
                        throw new IllegalStateException("Shaped recipe must have ingredient count equal to width * height.");
                    }
                    helper.writeVarInt(out, ((ShapedRecipeData)data).getWidth());
                    helper.writeVarInt(out, ((ShapedRecipeData)data).getHeight());
                    helper.writeString(out, ((ShapedRecipeData)data).getGroup());
                    for (Ingredient ingredient : ((ShapedRecipeData)data).getIngredients()) {
                        helper.writeRecipeIngredient(out, ingredient);
                    }
                    helper.writeItemStack(out, ((ShapedRecipeData)data).getResult());
                    continue block7;
                }
                case SMELTING: 
                case BLASTING: 
                case SMOKING: 
                case CAMPFIRE_COOKING: {
                    RecipeData data = (CookedRecipeData)recipe.getData();
                    helper.writeString(out, ((CookedRecipeData)data).getGroup());
                    helper.writeRecipeIngredient(out, ((CookedRecipeData)data).getIngredient());
                    helper.writeItemStack(out, ((CookedRecipeData)data).getResult());
                    out.writeFloat(((CookedRecipeData)data).getExperience());
                    helper.writeVarInt(out, ((CookedRecipeData)data).getCookingTime());
                    continue block7;
                }
                case STONECUTTING: {
                    RecipeData data = (StoneCuttingRecipeData)recipe.getData();
                    helper.writeString(out, ((StoneCuttingRecipeData)data).getGroup());
                    helper.writeRecipeIngredient(out, ((StoneCuttingRecipeData)data).getIngredient());
                    helper.writeItemStack(out, ((StoneCuttingRecipeData)data).getResult());
                    continue block7;
                }
                case SMITHING: {
                    RecipeData data = (SmithingRecipeData)recipe.getData();
                    helper.writeRecipeIngredient(out, ((SmithingRecipeData)data).getBase());
                    helper.writeRecipeIngredient(out, ((SmithingRecipeData)data).getAddition());
                    helper.writeItemStack(out, ((SmithingRecipeData)data).getResult());
                    continue block7;
                }
            }
        }
    }

    @NonNull
    public Recipe[] getRecipes() {
        return this.recipes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateRecipesPacket)) {
            return false;
        }
        ClientboundUpdateRecipesPacket other = (ClientboundUpdateRecipesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getRecipes(), other.getRecipes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateRecipesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getRecipes());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateRecipesPacket(recipes=" + Arrays.deepToString(this.getRecipes()) + ")";
    }

    public ClientboundUpdateRecipesPacket withRecipes(@NonNull Recipe[] recipes) {
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        return this.recipes == recipes ? this : new ClientboundUpdateRecipesPacket(recipes);
    }

    public ClientboundUpdateRecipesPacket(@NonNull Recipe[] recipes) {
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        this.recipes = recipes;
    }
}

