/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.kyori.adventure.text.Component;

public class ClientboundSystemChatPacket
implements MinecraftPacket {
    private final Component content;
    private final int typeId;

    public ClientboundSystemChatPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.content = helper.readComponent(in);
        this.typeId = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, (String)DefaultComponentSerializer.get().serialize(this.content));
        helper.writeVarInt(out, this.typeId);
    }

    public Component getContent() {
        return this.content;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSystemChatPacket)) {
            return false;
        }
        ClientboundSystemChatPacket other = (ClientboundSystemChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTypeId() != other.getTypeId()) {
            return false;
        }
        Component this$content = this.getContent();
        Component other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSystemChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTypeId();
        Component $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundSystemChatPacket(content=" + this.getContent() + ", typeId=" + this.getTypeId() + ")";
    }

    public ClientboundSystemChatPacket withContent(Component content) {
        return this.content == content ? this : new ClientboundSystemChatPacket(content, this.typeId);
    }

    public ClientboundSystemChatPacket withTypeId(int typeId) {
        return this.typeId == typeId ? this : new ClientboundSystemChatPacket(this.content, typeId);
    }

    public ClientboundSystemChatPacket(Component content, int typeId) {
        this.content = content;
        this.typeId = typeId;
    }
}

