/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.PlayerListEntry;
import com.github.steveice10.mc.protocol.data.game.PlayerListEntryAction;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ClientboundPlayerInfoPacket
implements MinecraftPacket {
    @NonNull
    private final PlayerListEntryAction action;
    @NonNull
    private final PlayerListEntry[] entries;

    public ClientboundPlayerInfoPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.action = MagicValues.key(PlayerListEntryAction.class, helper.readVarInt(in));
        this.entries = new PlayerListEntry[helper.readVarInt(in)];
        for (int count = 0; count < this.entries.length; ++count) {
            UUID uuid = helper.readUUID(in);
            GameProfile profile = this.action == PlayerListEntryAction.ADD_PLAYER ? new GameProfile(uuid, helper.readString(in)) : new GameProfile(uuid, null);
            PlayerListEntry entry = null;
            switch (this.action) {
                case ADD_PLAYER: {
                    long expiresAt;
                    int properties = helper.readVarInt(in);
                    ArrayList<GameProfile.Property> propertyList = new ArrayList<GameProfile.Property>();
                    for (int index = 0; index < properties; ++index) {
                        String propertyName = helper.readString(in);
                        String value = helper.readString(in);
                        String signature = null;
                        if (in.readBoolean()) {
                            signature = helper.readString(in);
                        }
                        propertyList.add(new GameProfile.Property(propertyName, value, signature));
                    }
                    profile.setProperties(propertyList);
                    int rawGameMode = helper.readVarInt(in);
                    GameMode gameMode = MagicValues.key(GameMode.class, Math.max(rawGameMode, 0));
                    int ping = helper.readVarInt(in);
                    Component displayName = null;
                    if (in.readBoolean()) {
                        displayName = helper.readComponent(in);
                    }
                    PublicKey publicKey = null;
                    byte[] keySignature = null;
                    if (in.readBoolean()) {
                        expiresAt = in.readLong();
                        byte[] keyBytes = helper.readByteArray(in);
                        keySignature = helper.readByteArray(in);
                        try {
                            publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
                        }
                        catch (GeneralSecurityException e) {
                            throw new IOException("Could not decode public key.", e);
                        }
                    } else {
                        expiresAt = 0L;
                    }
                    entry = new PlayerListEntry(profile, gameMode, ping, displayName, expiresAt, publicKey, keySignature);
                    break;
                }
                case UPDATE_GAMEMODE: {
                    int rawGameMode = helper.readVarInt(in);
                    GameMode mode = MagicValues.key(GameMode.class, Math.max(rawGameMode, 0));
                    entry = new PlayerListEntry(profile, mode);
                    break;
                }
                case UPDATE_LATENCY: {
                    int ping = helper.readVarInt(in);
                    entry = new PlayerListEntry(profile, ping);
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    Component displayName = null;
                    if (in.readBoolean()) {
                        displayName = helper.readComponent(in);
                    }
                    entry = new PlayerListEntry(profile, displayName);
                    break;
                }
                case REMOVE_PLAYER: {
                    entry = new PlayerListEntry(profile);
                }
            }
            this.entries[count] = entry;
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, MagicValues.value(Integer.class, (Object)this.action));
        helper.writeVarInt(out, this.entries.length);
        block6: for (PlayerListEntry entry : this.entries) {
            helper.writeUUID(out, entry.getProfile().getId());
            switch (this.action) {
                case ADD_PLAYER: {
                    helper.writeString(out, entry.getProfile().getName());
                    helper.writeVarInt(out, entry.getProfile().getProperties().size());
                    for (GameProfile.Property property : entry.getProfile().getProperties()) {
                        helper.writeString(out, property.getName());
                        helper.writeString(out, property.getValue());
                        out.writeBoolean(property.hasSignature());
                        if (!property.hasSignature()) continue;
                        helper.writeString(out, property.getSignature());
                    }
                    helper.writeVarInt(out, MagicValues.value(Integer.class, entry.getGameMode()));
                    helper.writeVarInt(out, entry.getPing());
                    out.writeBoolean(entry.getDisplayName() != null);
                    if (entry.getDisplayName() != null) {
                        helper.writeString(out, (String)DefaultComponentSerializer.get().serialize(entry.getDisplayName()));
                    }
                    if (entry.getPublicKey() == null) continue block6;
                    out.writeLong(entry.getExpiresAt());
                    byte[] encoded = entry.getPublicKey().getEncoded();
                    helper.writeVarInt(out, encoded.length);
                    out.writeBytes(encoded);
                    helper.writeVarInt(out, entry.getKeySignature().length);
                    out.writeBytes(entry.getKeySignature());
                    continue block6;
                }
                case UPDATE_GAMEMODE: {
                    helper.writeVarInt(out, MagicValues.value(Integer.class, entry.getGameMode()));
                    continue block6;
                }
                case UPDATE_LATENCY: {
                    helper.writeVarInt(out, entry.getPing());
                    continue block6;
                }
                case UPDATE_DISPLAY_NAME: {
                    out.writeBoolean(entry.getDisplayName() != null);
                    if (entry.getDisplayName() == null) continue block6;
                    helper.writeString(out, (String)DefaultComponentSerializer.get().serialize(entry.getDisplayName()));
                    continue block6;
                }
            }
        }
    }

    @NonNull
    public PlayerListEntryAction getAction() {
        return this.action;
    }

    @NonNull
    public PlayerListEntry[] getEntries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerInfoPacket)) {
            return false;
        }
        ClientboundPlayerInfoPacket other = (ClientboundPlayerInfoPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerListEntryAction this$action = this.getAction();
        PlayerListEntryAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        return Arrays.deepEquals(this.getEntries(), other.getEntries());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerInfoPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerListEntryAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEntries());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerInfoPacket(action=" + (Object)((Object)this.getAction()) + ", entries=" + Arrays.deepToString(this.getEntries()) + ")";
    }

    public ClientboundPlayerInfoPacket withAction(@NonNull PlayerListEntryAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientboundPlayerInfoPacket(action, this.entries);
    }

    public ClientboundPlayerInfoPacket withEntries(@NonNull PlayerListEntry[] entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return this.entries == entries ? this : new ClientboundPlayerInfoPacket(this.action, entries);
    }

    public ClientboundPlayerInfoPacket(@NonNull PlayerListEntryAction action, @NonNull PlayerListEntry[] entries) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        this.action = action;
        this.entries = entries;
    }
}

