/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClientboundPlayerChatPacket
implements MinecraftPacket {
    private final Component signedContent;
    @Nullable
    private final Component unsignedContent;
    private final int typeId;
    private final UUID senderUUID;
    private final Component senderName;
    @Nullable
    private final Component senderTeamName;
    private final long salt;
    private final byte[] signature;
    private final long timeStamp;

    public ClientboundPlayerChatPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.signedContent = helper.readComponent(in);
        this.unsignedContent = in.readBoolean() ? helper.readComponent(in) : null;
        this.typeId = helper.readVarInt(in);
        this.senderUUID = helper.readUUID(in);
        this.senderName = helper.readComponent(in);
        this.senderTeamName = in.readBoolean() ? helper.readComponent(in) : null;
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.signature = helper.readByteArray(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeComponent(out, this.signedContent);
        if (this.unsignedContent != null) {
            helper.writeComponent(out, this.unsignedContent);
        }
        helper.writeVarInt(out, this.typeId);
        helper.writeUUID(out, this.senderUUID);
        DefaultComponentSerializer.get().serialize(this.senderName);
        if (this.senderTeamName != null) {
            DefaultComponentSerializer.get().serialize(this.senderTeamName);
        }
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        helper.writeVarInt(out, this.signature.length);
        out.writeBytes(this.signature);
    }

    public Component getSignedContent() {
        return this.signedContent;
    }

    @Nullable
    public Component getUnsignedContent() {
        return this.unsignedContent;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public UUID getSenderUUID() {
        return this.senderUUID;
    }

    public Component getSenderName() {
        return this.senderName;
    }

    @Nullable
    public Component getSenderTeamName() {
        return this.senderTeamName;
    }

    public long getSalt() {
        return this.salt;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerChatPacket)) {
            return false;
        }
        ClientboundPlayerChatPacket other = (ClientboundPlayerChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTypeId() != other.getTypeId()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        Component this$signedContent = this.getSignedContent();
        Component other$signedContent = other.getSignedContent();
        if (this$signedContent == null ? other$signedContent != null : !this$signedContent.equals(other$signedContent)) {
            return false;
        }
        Component this$unsignedContent = this.getUnsignedContent();
        Component other$unsignedContent = other.getUnsignedContent();
        if (this$unsignedContent == null ? other$unsignedContent != null : !this$unsignedContent.equals(other$unsignedContent)) {
            return false;
        }
        UUID this$senderUUID = this.getSenderUUID();
        UUID other$senderUUID = other.getSenderUUID();
        if (this$senderUUID == null ? other$senderUUID != null : !((Object)this$senderUUID).equals(other$senderUUID)) {
            return false;
        }
        Component this$senderName = this.getSenderName();
        Component other$senderName = other.getSenderName();
        if (this$senderName == null ? other$senderName != null : !this$senderName.equals(other$senderName)) {
            return false;
        }
        Component this$senderTeamName = this.getSenderTeamName();
        Component other$senderTeamName = other.getSenderTeamName();
        if (this$senderTeamName == null ? other$senderTeamName != null : !this$senderTeamName.equals(other$senderTeamName)) {
            return false;
        }
        return Arrays.equals(this.getSignature(), other.getSignature());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTypeId();
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        Component $signedContent = this.getSignedContent();
        result = result * 59 + ($signedContent == null ? 43 : $signedContent.hashCode());
        Component $unsignedContent = this.getUnsignedContent();
        result = result * 59 + ($unsignedContent == null ? 43 : $unsignedContent.hashCode());
        UUID $senderUUID = this.getSenderUUID();
        result = result * 59 + ($senderUUID == null ? 43 : ((Object)$senderUUID).hashCode());
        Component $senderName = this.getSenderName();
        result = result * 59 + ($senderName == null ? 43 : $senderName.hashCode());
        Component $senderTeamName = this.getSenderTeamName();
        result = result * 59 + ($senderTeamName == null ? 43 : $senderTeamName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerChatPacket(signedContent=" + this.getSignedContent() + ", unsignedContent=" + this.getUnsignedContent() + ", typeId=" + this.getTypeId() + ", senderUUID=" + this.getSenderUUID() + ", senderName=" + this.getSenderName() + ", senderTeamName=" + this.getSenderTeamName() + ", salt=" + this.getSalt() + ", timeStamp=" + this.getTimeStamp() + ")";
    }

    public ClientboundPlayerChatPacket withSignedContent(Component signedContent) {
        return this.signedContent == signedContent ? this : new ClientboundPlayerChatPacket(signedContent, this.unsignedContent, this.typeId, this.senderUUID, this.senderName, this.senderTeamName, this.salt, this.signature, this.timeStamp);
    }

    public ClientboundPlayerChatPacket withUnsignedContent(@Nullable Component unsignedContent) {
        return this.unsignedContent == unsignedContent ? this : new ClientboundPlayerChatPacket(this.signedContent, unsignedContent, this.typeId, this.senderUUID, this.senderName, this.senderTeamName, this.salt, this.signature, this.timeStamp);
    }

    public ClientboundPlayerChatPacket withTypeId(int typeId) {
        return this.typeId == typeId ? this : new ClientboundPlayerChatPacket(this.signedContent, this.unsignedContent, typeId, this.senderUUID, this.senderName, this.senderTeamName, this.salt, this.signature, this.timeStamp);
    }

    public ClientboundPlayerChatPacket withSenderUUID(UUID senderUUID) {
        return this.senderUUID == senderUUID ? this : new ClientboundPlayerChatPacket(this.signedContent, this.unsignedContent, this.typeId, senderUUID, this.senderName, this.senderTeamName, this.salt, this.signature, this.timeStamp);
    }

    public ClientboundPlayerChatPacket withSenderName(Component senderName) {
        return this.senderName == senderName ? this : new ClientboundPlayerChatPacket(this.signedContent, this.unsignedContent, this.typeId, this.senderUUID, senderName, this.senderTeamName, this.salt, this.signature, this.timeStamp);
    }

    public ClientboundPlayerChatPacket withSenderTeamName(@Nullable Component senderTeamName) {
        return this.senderTeamName == senderTeamName ? this : new ClientboundPlayerChatPacket(this.signedContent, this.unsignedContent, this.typeId, this.senderUUID, this.senderName, senderTeamName, this.salt, this.signature, this.timeStamp);
    }

    public ClientboundPlayerChatPacket withSalt(long salt) {
        return this.salt == salt ? this : new ClientboundPlayerChatPacket(this.signedContent, this.unsignedContent, this.typeId, this.senderUUID, this.senderName, this.senderTeamName, salt, this.signature, this.timeStamp);
    }

    public ClientboundPlayerChatPacket withSignature(byte[] signature) {
        return this.signature == signature ? this : new ClientboundPlayerChatPacket(this.signedContent, this.unsignedContent, this.typeId, this.senderUUID, this.senderName, this.senderTeamName, this.salt, signature, this.timeStamp);
    }

    public ClientboundPlayerChatPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ClientboundPlayerChatPacket(this.signedContent, this.unsignedContent, this.typeId, this.senderUUID, this.senderName, this.senderTeamName, this.salt, this.signature, timeStamp);
    }

    public ClientboundPlayerChatPacket(Component signedContent, @Nullable Component unsignedContent, int typeId, UUID senderUUID, Component senderName, @Nullable Component senderTeamName, long salt, byte[] signature, long timeStamp) {
        this.signedContent = signedContent;
        this.unsignedContent = unsignedContent;
        this.typeId = typeId;
        this.senderUUID = senderUUID;
        this.senderName = senderName;
        this.senderTeamName = senderTeamName;
        this.salt = salt;
        this.signature = signature;
        this.timeStamp = timeStamp;
    }
}

