/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ClientboundCommandSuggestionsPacket
implements MinecraftPacket {
    private final int transactionId;
    private final int start;
    private final int length;
    @NonNull
    private final String[] matches;
    @NonNull
    private final Component[] tooltips;

    public ClientboundCommandSuggestionsPacket(int transactionId, int start, int length, @NonNull String[] matches, @NonNull Component[] tooltips) {
        if (matches == null) {
            throw new NullPointerException("matches is marked non-null but is null");
        }
        if (tooltips == null) {
            throw new NullPointerException("tooltips is marked non-null but is null");
        }
        if (tooltips.length != matches.length) {
            throw new IllegalArgumentException("Length of matches and tooltips must be equal.");
        }
        this.transactionId = transactionId;
        this.start = start;
        this.length = length;
        this.matches = Arrays.copyOf(matches, matches.length);
        this.tooltips = Arrays.copyOf(tooltips, tooltips.length);
    }

    public ClientboundCommandSuggestionsPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.transactionId = helper.readVarInt(in);
        this.start = helper.readVarInt(in);
        this.length = helper.readVarInt(in);
        this.matches = new String[helper.readVarInt(in)];
        this.tooltips = new Component[this.matches.length];
        for (int index = 0; index < this.matches.length; ++index) {
            this.matches[index] = helper.readString(in);
            if (!in.readBoolean()) continue;
            this.tooltips[index] = helper.readComponent(in);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.transactionId);
        helper.writeVarInt(out, this.start);
        helper.writeVarInt(out, this.length);
        helper.writeVarInt(out, this.matches.length);
        for (int index = 0; index < this.matches.length; ++index) {
            helper.writeString(out, this.matches[index]);
            Component tooltip = this.tooltips[index];
            if (tooltip != null) {
                out.writeBoolean(true);
                helper.writeString(out, (String)DefaultComponentSerializer.get().serialize(tooltip));
                continue;
            }
            out.writeBoolean(false);
        }
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    @NonNull
    public String[] getMatches() {
        return this.matches;
    }

    @NonNull
    public Component[] getTooltips() {
        return this.tooltips;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCommandSuggestionsPacket)) {
            return false;
        }
        ClientboundCommandSuggestionsPacket other = (ClientboundCommandSuggestionsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMatches(), other.getMatches())) {
            return false;
        }
        return Arrays.deepEquals(this.getTooltips(), other.getTooltips());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundCommandSuggestionsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + this.getStart();
        result = result * 59 + this.getLength();
        result = result * 59 + Arrays.deepHashCode(this.getMatches());
        result = result * 59 + Arrays.deepHashCode(this.getTooltips());
        return result;
    }

    public String toString() {
        return "ClientboundCommandSuggestionsPacket(transactionId=" + this.getTransactionId() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", matches=" + Arrays.deepToString(this.getMatches()) + ", tooltips=" + Arrays.deepToString(this.getTooltips()) + ")";
    }

    public ClientboundCommandSuggestionsPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ClientboundCommandSuggestionsPacket(transactionId, this.start, this.length, this.matches, this.tooltips);
    }

    public ClientboundCommandSuggestionsPacket withStart(int start) {
        return this.start == start ? this : new ClientboundCommandSuggestionsPacket(this.transactionId, start, this.length, this.matches, this.tooltips);
    }

    public ClientboundCommandSuggestionsPacket withLength(int length) {
        return this.length == length ? this : new ClientboundCommandSuggestionsPacket(this.transactionId, this.start, length, this.matches, this.tooltips);
    }

    public ClientboundCommandSuggestionsPacket withMatches(@NonNull String[] matches) {
        if (matches == null) {
            throw new NullPointerException("matches is marked non-null but is null");
        }
        return this.matches == matches ? this : new ClientboundCommandSuggestionsPacket(this.transactionId, this.start, this.length, matches, this.tooltips);
    }

    public ClientboundCommandSuggestionsPacket withTooltips(@NonNull Component[] tooltips) {
        if (tooltips == null) {
            throw new NullPointerException("tooltips is marked non-null but is null");
        }
        return this.tooltips == tooltips ? this : new ClientboundCommandSuggestionsPacket(this.transactionId, this.start, this.length, this.matches, tooltips);
    }
}

