/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.metadata;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.BooleanMetadataType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ByteMetadataType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.FloatMetadataType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.GlobalPos;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.IntMetadataType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.OptionalIntMetadataType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Pose;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.VillagerData;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.type.PaintingType;
import com.github.steveice10.mc.protocol.data.game.level.particle.Particle;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.codec.BasePacketCodecHelper;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;

public class MetadataType<T> {
    private static final List<MetadataType<?>> VALUES = new ArrayList();
    public static final ByteMetadataType BYTE = new ByteMetadataType(ByteBuf::readByte, ByteBuf::writeByte, ByteEntityMetadata::new);
    public static final IntMetadataType INT = new IntMetadataType(BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntEntityMetadata::new);
    public static final FloatMetadataType FLOAT = new FloatMetadataType(ByteBuf::readFloat, ByteBuf::writeFloat, FloatEntityMetadata::new);
    public static final MetadataType<String> STRING = new MetadataType<String>(BasePacketCodecHelper::readString, BasePacketCodecHelper::writeString, ObjectEntityMetadata::new);
    public static final MetadataType<Component> CHAT = new MetadataType<Component>(MinecraftCodecHelper::readComponent, MinecraftCodecHelper::writeComponent, ObjectEntityMetadata::new);
    public static final MetadataType<Optional<Component>> OPTIONAL_CHAT = new MetadataType<Optional>(MetadataType.optionalReader(MinecraftCodecHelper::readComponent), MetadataType.optionalWriter(MinecraftCodecHelper::writeComponent), ObjectEntityMetadata::new);
    public static final MetadataType<ItemStack> ITEM = new MetadataType<ItemStack>(MinecraftCodecHelper::readItemStack, MinecraftCodecHelper::writeItemStack, ObjectEntityMetadata::new);
    public static final BooleanMetadataType BOOLEAN = new BooleanMetadataType(ByteBuf::readBoolean, ByteBuf::writeBoolean, BooleanEntityMetadata::new);
    public static final MetadataType<Vector3f> ROTATION = new MetadataType<Vector3f>(MinecraftCodecHelper::readRotation, MinecraftCodecHelper::writeRotation, ObjectEntityMetadata::new);
    public static final MetadataType<Vector3i> POSITION = new MetadataType<Vector3i>(MinecraftCodecHelper::readPosition, MinecraftCodecHelper::writePosition, ObjectEntityMetadata::new);
    public static final MetadataType<Optional<Vector3i>> OPTIONAL_POSITION = new MetadataType<Optional>(MetadataType.optionalReader(MinecraftCodecHelper::readPosition), MetadataType.optionalWriter(MinecraftCodecHelper::writePosition), ObjectEntityMetadata::new);
    public static final MetadataType<Direction> DIRECTION = new MetadataType<Direction>(MinecraftCodecHelper::readDirection, MinecraftCodecHelper::writeDirection, ObjectEntityMetadata::new);
    public static final MetadataType<Optional<UUID>> OPTIONAL_UUID = new MetadataType<Optional>(MetadataType.optionalReader(MinecraftCodecHelper::readUUID), MetadataType.optionalWriter(MinecraftCodecHelper::writeUUID), ObjectEntityMetadata::new);
    public static final IntMetadataType BLOCK_STATE = new IntMetadataType(BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntEntityMetadata::new);
    public static final MetadataType<CompoundTag> NBT_TAG = new MetadataType<CompoundTag>(MinecraftCodecHelper::readTag, MinecraftCodecHelper::writeTag, ObjectEntityMetadata::new);
    public static final MetadataType<Particle> PARTICLE = new MetadataType<Particle>(MinecraftCodecHelper::readParticle, MinecraftCodecHelper::writeParticle, ObjectEntityMetadata::new);
    public static final MetadataType<VillagerData> VILLAGER_DATA = new MetadataType<VillagerData>(MinecraftCodecHelper::readVillagerData, MinecraftCodecHelper::writeVillagerData, ObjectEntityMetadata::new);
    public static final OptionalIntMetadataType OPTIONAL_VARINT = new OptionalIntMetadataType(ObjectEntityMetadata::new);
    public static final MetadataType<Pose> POSE = new MetadataType<Pose>(MinecraftCodecHelper::readPose, MinecraftCodecHelper::writePose, ObjectEntityMetadata::new);
    public static final IntMetadataType CAT_VARIANT = new IntMetadataType(BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntEntityMetadata::new);
    public static final IntMetadataType FROG_VARIANT = new IntMetadataType(BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntEntityMetadata::new);
    public static final MetadataType<Optional<GlobalPos>> OPTIONAL_GLOBAL_POS = new MetadataType<Optional>(MetadataType.optionalReader(MinecraftCodecHelper::readGlobalPos), MetadataType.optionalWriter(MinecraftCodecHelper::writeGlobalPos), ObjectEntityMetadata::new);
    public static final MetadataType<PaintingType> PAINTING_VARIANT = new MetadataType<PaintingType>(MinecraftCodecHelper::readPaintingType, MinecraftCodecHelper::writePaintingType, ObjectEntityMetadata::new);
    protected final int id = VALUES.size();
    protected final Reader<T> reader;
    protected final Writer<T> writer;
    protected final EntityMetadataFactory<T> metadataFactory;

    protected MetadataType(BasicReader<T> reader, BasicWriter<T> writer, EntityMetadataFactory<T> metadataFactory) {
        this.reader = reader;
        this.writer = writer;
        this.metadataFactory = metadataFactory;
        VALUES.add(this);
    }

    protected MetadataType(HelperReader<T> reader, HelperWriter<T> writer, EntityMetadataFactory<T> metadataFactory) {
        this.reader = reader;
        this.writer = writer;
        this.metadataFactory = metadataFactory;
        VALUES.add(this);
    }

    public EntityMetadata<T, ? extends MetadataType<T>> readMetadata(MinecraftCodecHelper helper, ByteBuf input, int id) throws IOException {
        return this.metadataFactory.create(id, this, this.reader.read(helper, input));
    }

    public void writeMetadata(MinecraftCodecHelper helper, ByteBuf output, T value) throws IOException {
        this.writer.write(helper, output, value);
    }

    private static <T> BasicReader<Optional<T>> optionalReader(BasicReader<T> reader) {
        return input -> {
            if (!input.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(reader.read(input));
        };
    }

    private static <T> HelperReader<Optional<T>> optionalReader(HelperReader<T> reader) {
        return (helper, input) -> {
            if (!input.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(reader.read(helper, input));
        };
    }

    private static <T> BasicWriter<Optional<T>> optionalWriter(BasicWriter<T> writer) {
        return (ouput, value) -> {
            ouput.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                writer.write(ouput, value.get());
            }
        };
    }

    private static <T> HelperWriter<Optional<T>> optionalWriter(HelperWriter<T> writer) {
        return (helper, ouput, value) -> {
            ouput.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                writer.write(helper, ouput, value.get());
            }
        };
    }

    public static MetadataType<?> read(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        int id = helper.readVarInt(in);
        if (id >= VALUES.size()) {
            throw new IllegalArgumentException("Received id " + id + " for MetadataType when the maximum was " + VALUES.size() + "!");
        }
        return VALUES.get(id);
    }

    public static MetadataType<?> from(int id) {
        return VALUES.get(id);
    }

    public static int size() {
        return VALUES.size();
    }

    public int getId() {
        return this.id;
    }

    public Reader<T> getReader() {
        return this.reader;
    }

    public Writer<T> getWriter() {
        return this.writer;
    }

    public EntityMetadataFactory<T> getMetadataFactory() {
        return this.metadataFactory;
    }

    @FunctionalInterface
    public static interface EntityMetadataFactory<V> {
        public EntityMetadata<V, ? extends MetadataType<V>> create(int var1, MetadataType<V> var2, V var3);
    }

    @FunctionalInterface
    public static interface HelperWriter<V>
    extends Writer<V> {
        @Override
        default public void write(ByteBuf output, V value) throws IOException {
            throw new UnsupportedOperationException("This writer needs a codec helper!");
        }

        @Override
        public void write(MinecraftCodecHelper var1, ByteBuf var2, V var3) throws IOException;
    }

    @FunctionalInterface
    public static interface HelperReader<V>
    extends Reader<V> {
        @Override
        default public V read(ByteBuf input) throws IOException {
            throw new UnsupportedOperationException("This reader needs a codec helper!");
        }

        @Override
        public V read(MinecraftCodecHelper var1, ByteBuf var2) throws IOException;
    }

    @FunctionalInterface
    public static interface BasicWriter<V>
    extends Writer<V> {
        @Override
        public void write(ByteBuf var1, V var2) throws IOException;

        @Override
        default public void write(MinecraftCodecHelper helper, ByteBuf output, V value) throws IOException {
            this.write(output, value);
        }
    }

    @FunctionalInterface
    public static interface BasicReader<V>
    extends Reader<V> {
        @Override
        public V read(ByteBuf var1) throws IOException;

        @Override
        default public V read(MinecraftCodecHelper helper, ByteBuf input) throws IOException {
            return this.read(input);
        }
    }

    public static interface Writer<V> {
        public void write(ByteBuf var1, V var2) throws IOException;

        public void write(MinecraftCodecHelper var1, ByteBuf var2, V var3) throws IOException;
    }

    public static interface Reader<V> {
        public V read(ByteBuf var1) throws IOException;

        public V read(MinecraftCodecHelper var1, ByteBuf var2) throws IOException;
    }
}

