/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.service.SessionService;
import com.github.steveice10.mc.protocol.MinecraftProtocol;
import com.github.steveice10.mc.protocol.ServerLoginHandler;
import com.github.steveice10.mc.protocol.data.ProtocolState;
import com.github.steveice10.mc.protocol.data.status.PlayerInfo;
import com.github.steveice10.mc.protocol.data.status.ServerStatusInfo;
import com.github.steveice10.mc.protocol.data.status.VersionInfo;
import com.github.steveice10.mc.protocol.data.status.handler.ServerInfoBuilder;
import com.github.steveice10.mc.protocol.packet.handshake.serverbound.ClientIntentionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.ServerboundKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundGameProfilePacket;
import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundHelloPacket;
import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundLoginCompressionPacket;
import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundLoginDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.login.serverbound.ServerboundHelloPacket;
import com.github.steveice10.mc.protocol.packet.login.serverbound.ServerboundKeyPacket;
import com.github.steveice10.mc.protocol.packet.status.clientbound.ClientboundPongResponsePacket;
import com.github.steveice10.mc.protocol.packet.status.clientbound.ClientboundStatusResponsePacket;
import com.github.steveice10.mc.protocol.packet.status.serverbound.ServerboundPingRequestPacket;
import com.github.steveice10.mc.protocol.packet.status.serverbound.ServerboundStatusRequestPacket;
import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.event.session.ConnectedEvent;
import com.github.steveice10.packetlib.event.session.DisconnectingEvent;
import com.github.steveice10.packetlib.event.session.SessionAdapter;
import com.github.steveice10.packetlib.packet.Packet;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;

public class ServerListener
extends SessionAdapter {
    private static final int DEFAULT_COMPRESSION_THRESHOLD = 256;
    private static final String SERVER_ID = "";
    private static final KeyPair KEY_PAIR;
    private byte[] verifyToken = new byte[4];
    private String username = "";
    private long lastPingTime = 0L;
    private int lastPingId = 0;

    public ServerListener() {
        new Random().nextBytes(this.verifyToken);
    }

    public void connected(ConnectedEvent event) {
        event.getSession().setFlag("ping", (Object)0);
    }

    public void packetReceived(Session session, Packet packet) {
        MinecraftProtocol protocol = (MinecraftProtocol)session.getPacketProtocol();
        if (protocol.getState() == ProtocolState.HANDSHAKE && packet instanceof ClientIntentionPacket) {
            ClientIntentionPacket intentionPacket = (ClientIntentionPacket)packet;
            switch (intentionPacket.getIntent()) {
                case STATUS: {
                    protocol.setState(ProtocolState.STATUS);
                    break;
                }
                case LOGIN: {
                    protocol.setState(ProtocolState.LOGIN);
                    if (intentionPacket.getProtocolVersion() > protocol.getCodec().getProtocolVersion()) {
                        session.disconnect("Outdated server! I'm still on " + protocol.getCodec().getMinecraftVersion() + ".");
                        break;
                    }
                    if (intentionPacket.getProtocolVersion() >= protocol.getCodec().getProtocolVersion()) break;
                    session.disconnect("Outdated client! Please use " + protocol.getCodec().getMinecraftVersion() + ".");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid client intent: " + (Object)((Object)intentionPacket.getIntent()));
                }
            }
        }
        if (protocol.getState() == ProtocolState.LOGIN) {
            if (packet instanceof ServerboundHelloPacket) {
                this.username = ((ServerboundHelloPacket)packet).getUsername();
                if (((Boolean)session.getFlag("verify-users", (Object)true)).booleanValue()) {
                    session.send((Packet)new ClientboundHelloPacket(SERVER_ID, KEY_PAIR.getPublic(), this.verifyToken));
                } else {
                    new Thread(new UserAuthTask(session, null)).start();
                }
            } else if (packet instanceof ServerboundKeyPacket) {
                ServerboundKeyPacket keyPacket = (ServerboundKeyPacket)packet;
                PrivateKey privateKey = KEY_PAIR.getPrivate();
                if (!Arrays.equals(this.verifyToken, keyPacket.getVerifyToken(privateKey))) {
                    session.disconnect("Invalid nonce!");
                    return;
                }
                SecretKey key = keyPacket.getSecretKey(privateKey);
                session.enableEncryption(protocol.enableEncryption(key));
                new Thread(new UserAuthTask(session, key)).start();
            }
        }
        if (protocol.getState() == ProtocolState.STATUS) {
            if (packet instanceof ServerboundStatusRequestPacket) {
                ServerInfoBuilder builder = (ServerInfoBuilder)session.getFlag("info-builder");
                if (builder == null) {
                    builder = $ -> new ServerStatusInfo(new VersionInfo(protocol.getCodec().getMinecraftVersion(), protocol.getCodec().getProtocolVersion()), new PlayerInfo(0, 20, new GameProfile[0]), (Component)Component.text((String)"A Minecraft Server"), null, false);
                }
                ServerStatusInfo info = builder.buildInfo(session);
                session.send((Packet)new ClientboundStatusResponsePacket(info));
            } else if (packet instanceof ServerboundPingRequestPacket) {
                session.send((Packet)new ClientboundPongResponsePacket(((ServerboundPingRequestPacket)packet).getPingTime()));
            }
        }
        if (protocol.getState() == ProtocolState.GAME && packet instanceof ServerboundKeepAlivePacket && ((ServerboundKeepAlivePacket)packet).getPingId() == (long)this.lastPingId) {
            long time = System.currentTimeMillis() - this.lastPingTime;
            session.setFlag("ping", (Object)time);
        }
    }

    public void packetSent(Session session, Packet packet) {
        if (packet instanceof ClientboundLoginCompressionPacket) {
            session.setCompressionThreshold(((ClientboundLoginCompressionPacket)packet).getThreshold(), true);
            session.send((Packet)new ClientboundGameProfilePacket((GameProfile)session.getFlag("profile")));
        } else if (packet instanceof ClientboundGameProfilePacket) {
            ((MinecraftProtocol)session.getPacketProtocol()).setState(ProtocolState.GAME);
            ServerLoginHandler handler = (ServerLoginHandler)session.getFlag("login-handler");
            if (handler != null) {
                handler.loggedIn(session);
            }
            if (((Boolean)session.getFlag("manage-keep-alive", (Object)true)).booleanValue()) {
                new Thread(new KeepAliveTask(session)).start();
            }
        }
    }

    public void disconnecting(DisconnectingEvent event) {
        MinecraftProtocol protocol = (MinecraftProtocol)event.getSession().getPacketProtocol();
        if (protocol.getState() == ProtocolState.LOGIN) {
            event.getSession().send((Packet)new ClientboundLoginDisconnectPacket(event.getReason()));
        } else if (protocol.getState() == ProtocolState.GAME) {
            event.getSession().send((Packet)new ClientboundDisconnectPacket(event.getReason()));
        }
    }

    static {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(1024);
            KEY_PAIR = gen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to generate server key pair.", e);
        }
    }

    private class KeepAliveTask
    implements Runnable {
        private Session session;

        public KeepAliveTask(Session session) {
            this.session = session;
        }

        @Override
        public void run() {
            while (this.session.isConnected()) {
                ServerListener.this.lastPingTime = System.currentTimeMillis();
                ServerListener.this.lastPingId = (int)ServerListener.this.lastPingTime;
                this.session.send((Packet)new ClientboundKeepAlivePacket(ServerListener.this.lastPingId));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    private class UserAuthTask
    implements Runnable {
        private Session session;
        private SecretKey key;

        public UserAuthTask(Session session, SecretKey key) {
            this.key = key;
            this.session = session;
        }

        @Override
        public void run() {
            GameProfile profile;
            if (this.key != null) {
                SessionService sessionService = (SessionService)this.session.getFlag("session-service", (Object)new SessionService());
                try {
                    profile = sessionService.getProfileByServer(ServerListener.this.username, sessionService.getServerId(ServerListener.SERVER_ID, KEY_PAIR.getPublic(), this.key));
                }
                catch (RequestException e) {
                    this.session.disconnect("Failed to make session service request.", (Throwable)e);
                    return;
                }
                if (profile == null) {
                    this.session.disconnect("Failed to verify username.");
                }
            } else {
                profile = new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + ServerListener.this.username).getBytes()), ServerListener.this.username);
            }
            this.session.setFlag("profile", (Object)profile);
            int threshold = (Integer)this.session.getFlag("compression-threshold", (Object)256);
            this.session.send((Packet)new ClientboundLoginCompressionPacket(threshold));
        }
    }
}

