/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.protocol.ClientListener;
import com.github.steveice10.mc.protocol.MinecraftConstants;
import com.github.steveice10.mc.protocol.ServerListener;
import com.github.steveice10.mc.protocol.codec.MinecraftCodec;
import com.github.steveice10.mc.protocol.codec.PacketCodec;
import com.github.steveice10.mc.protocol.codec.PacketStateCodec;
import com.github.steveice10.mc.protocol.data.ProtocolState;
import com.github.steveice10.packetlib.Server;
import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.codec.PacketCodecHelper;
import com.github.steveice10.packetlib.codec.PacketDefinition;
import com.github.steveice10.packetlib.crypt.AESEncryption;
import com.github.steveice10.packetlib.crypt.PacketEncryption;
import com.github.steveice10.packetlib.event.session.SessionListener;
import com.github.steveice10.packetlib.packet.Packet;
import com.github.steveice10.packetlib.packet.PacketHeader;
import com.github.steveice10.packetlib.packet.PacketProtocol;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.UUID;
import lombok.NonNull;

public class MinecraftProtocol
extends PacketProtocol {
    private final PacketCodec codec;
    private ProtocolState state;
    private PacketStateCodec stateCodec;
    private final ProtocolState targetState;
    private GameProfile profile;
    private String accessToken;
    private boolean useDefaultListeners = true;

    public MinecraftProtocol() {
        this(MinecraftCodec.CODEC);
    }

    public MinecraftProtocol(PacketCodec codec) {
        this.codec = codec;
        this.targetState = ProtocolState.STATUS;
        this.setState(ProtocolState.HANDSHAKE);
    }

    public MinecraftProtocol(@NonNull String username) {
        this(new GameProfile((UUID)null, username), null);
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull PacketCodec codec, @NonNull String username) {
        this(codec, new GameProfile((UUID)null, username), null);
        if (codec == null) {
            throw new NullPointerException("codec is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull GameProfile profile, String accessToken) {
        this(MinecraftCodec.CODEC, profile, accessToken);
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull PacketCodec codec, @NonNull GameProfile profile, String accessToken) {
        if (codec == null) {
            throw new NullPointerException("codec is marked non-null but is null");
        }
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        this.codec = codec;
        this.targetState = ProtocolState.LOGIN;
        this.profile = profile;
        this.accessToken = accessToken;
        this.setState(ProtocolState.HANDSHAKE);
    }

    public String getSRVRecordPrefix() {
        return "_minecraft";
    }

    public PacketHeader getPacketHeader() {
        return MinecraftConstants.PACKET_HEADER;
    }

    public PacketCodecHelper createHelper() {
        return (PacketCodecHelper)this.codec.getHelperFactory().get();
    }

    public void newClientSession(Session session) {
        session.setFlag("profile", (Object)this.profile);
        session.setFlag("access-token", (Object)this.accessToken);
        this.setState(ProtocolState.HANDSHAKE);
        if (this.useDefaultListeners) {
            session.addListener((SessionListener)new ClientListener(this.targetState));
        }
    }

    public void newServerSession(Server server, Session session) {
        this.setState(ProtocolState.HANDSHAKE);
        if (this.useDefaultListeners) {
            session.addListener((SessionListener)new ServerListener());
        }
    }

    protected PacketEncryption enableEncryption(Key key) {
        try {
            return new AESEncryption(key);
        }
        catch (GeneralSecurityException e) {
            throw new Error("Failed to enable protocol encryption.", e);
        }
    }

    public ProtocolState getState() {
        return this.state;
    }

    public void setState(ProtocolState state) {
        this.state = state;
        this.stateCodec = this.codec.getCodec(state);
    }

    public Packet createClientboundPacket(int id, ByteBuf buf, PacketCodecHelper codecHelper) throws IOException {
        return this.stateCodec.createClientboundPacket(id, buf, codecHelper);
    }

    public int getClientboundId(Class<? extends Packet> packetClass) {
        return this.stateCodec.getClientboundId(packetClass);
    }

    public int getClientboundId(Packet packet) {
        return this.stateCodec.getClientboundId(packet);
    }

    public Class<? extends Packet> getClientboundClass(int id) {
        return this.stateCodec.getClientboundClass(id);
    }

    public Packet createServerboundPacket(int id, ByteBuf buf, PacketCodecHelper codecHelper) throws IOException {
        return this.stateCodec.createServerboundPacket(id, buf, codecHelper);
    }

    public int getServerboundId(Class<? extends Packet> packetClass) {
        return this.stateCodec.getServerboundId(packetClass);
    }

    public int getServerboundId(Packet packet) {
        return this.stateCodec.getServerboundId(packet);
    }

    public Class<? extends Packet> getServerboundClass(int id) {
        return this.stateCodec.getServerboundClass(id);
    }

    public PacketDefinition<?, ?> getServerboundDefinition(int id) {
        return this.stateCodec.getServerboundDefinition(id);
    }

    public PacketDefinition<?, ?> getClientboundDefinition(int id) {
        return this.stateCodec.getClientboundDefinition(id);
    }

    public PacketCodec getCodec() {
        return this.codec;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
    }
}

