package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.With;

import java.io.IOException;

@Data
@With
@AllArgsConstructor
public class ClientboundPlayerCombatEndPacket implements MinecraftPacket {
    private final int killerId;
    private final int duration;

    public ClientboundPlayerCombatEndPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.duration = helper.readVarInt(in);
        this.killerId = in.readInt();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.duration);
        out.writeInt(this.killerId);
    }
}
