/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.level;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerboundEntityTagQuery
implements Packet {
    private final int transactionId;
    private final int entityId;

    public ServerboundEntityTagQuery(NetInput in) throws IOException {
        this.transactionId = in.readVarInt();
        this.entityId = in.readVarInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.transactionId);
        out.writeVarInt(this.entityId);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundEntityTagQuery)) {
            return false;
        }
        ServerboundEntityTagQuery other = (ServerboundEntityTagQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        return this.getEntityId() == other.getEntityId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundEntityTagQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + this.getEntityId();
        return result;
    }

    public String toString() {
        return "ServerboundEntityTagQuery(transactionId=" + this.getTransactionId() + ", entityId=" + this.getEntityId() + ")";
    }

    public ServerboundEntityTagQuery withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ServerboundEntityTagQuery(transactionId, this.entityId);
    }

    public ServerboundEntityTagQuery withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerboundEntityTagQuery(this.transactionId, entityId);
    }

    public ServerboundEntityTagQuery(int transactionId, int entityId) {
        this.transactionId = transactionId;
        this.entityId = entityId;
    }
}

