/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.spawn;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;

public class ClientboundAddPlayerPacket
implements Packet {
    private final int entityId;
    @NonNull
    private final UUID uuid;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;

    public ClientboundAddPlayerPacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.uuid = in.readUUID();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = (float)(in.readByte() * 360) / 256.0f;
        this.pitch = (float)(in.readByte() * 360) / 256.0f;
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeUUID(this.uuid);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeByte((int)((byte)(this.yaw * 256.0f / 360.0f)));
        out.writeByte((int)((byte)(this.pitch * 256.0f / 360.0f)));
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAddPlayerPacket)) {
            return false;
        }
        ClientboundAddPlayerPacket other = (ClientboundAddPlayerPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        return !(this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAddPlayerPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundAddPlayerPacket(entityId=" + this.getEntityId() + ", uuid=" + this.getUuid() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public ClientboundAddPlayerPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundAddPlayerPacket(entityId, this.uuid, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public ClientboundAddPlayerPacket withUuid(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return this.uuid == uuid ? this : new ClientboundAddPlayerPacket(this.entityId, uuid, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public ClientboundAddPlayerPacket withX(double x) {
        return this.x == x ? this : new ClientboundAddPlayerPacket(this.entityId, this.uuid, x, this.y, this.z, this.yaw, this.pitch);
    }

    public ClientboundAddPlayerPacket withY(double y) {
        return this.y == y ? this : new ClientboundAddPlayerPacket(this.entityId, this.uuid, this.x, y, this.z, this.yaw, this.pitch);
    }

    public ClientboundAddPlayerPacket withZ(double z) {
        return this.z == z ? this : new ClientboundAddPlayerPacket(this.entityId, this.uuid, this.x, this.y, z, this.yaw, this.pitch);
    }

    public ClientboundAddPlayerPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ClientboundAddPlayerPacket(this.entityId, this.uuid, this.x, this.y, this.z, yaw, this.pitch);
    }

    public ClientboundAddPlayerPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundAddPlayerPacket(this.entityId, this.uuid, this.x, this.y, this.z, this.yaw, pitch);
    }

    public ClientboundAddPlayerPacket(int entityId, @NonNull UUID uuid, double x, double y, double z, float yaw, float pitch) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.entityId = entityId;
        this.uuid = uuid;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }
}

