/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.spawn;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.object.FallingBlockData;
import com.github.steveice10.mc.protocol.data.game.entity.object.GenericObjectData;
import com.github.steveice10.mc.protocol.data.game.entity.object.MinecartType;
import com.github.steveice10.mc.protocol.data.game.entity.object.ObjectData;
import com.github.steveice10.mc.protocol.data.game.entity.object.ProjectileData;
import com.github.steveice10.mc.protocol.data.game.entity.object.SplashPotionData;
import com.github.steveice10.mc.protocol.data.game.entity.type.EntityType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;

public class ClientboundAddEntityPacket
implements Packet {
    private static final GenericObjectData EMPTY_DATA = new GenericObjectData(0);
    private final int entityId;
    @NonNull
    private final UUID uuid;
    @NonNull
    private final EntityType type;
    @NonNull
    private final ObjectData data;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    private final double motionX;
    private final double motionY;
    private final double motionZ;

    public ClientboundAddEntityPacket(int entityId, @NonNull UUID uuid, @NonNull EntityType type, double x, double y, double z, float yaw, float pitch) {
        this(entityId, uuid, type, EMPTY_DATA, x, y, z, yaw, pitch, 0.0, 0.0, 0.0);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public ClientboundAddEntityPacket(int entityId, @NonNull UUID uuid, @NonNull EntityType type, @NonNull ObjectData data, double x, double y, double z, float yaw, float pitch) {
        this(entityId, uuid, type, data, x, y, z, yaw, pitch, 0.0, 0.0, 0.0);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
    }

    public ClientboundAddEntityPacket(int entityId, @NonNull UUID uuid, @NonNull EntityType type, double x, double y, double z, float yaw, float pitch, double motionX, double motionY, double motionZ) {
        this(entityId, uuid, type, EMPTY_DATA, x, y, z, yaw, pitch, motionX, motionY, motionZ);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public ClientboundAddEntityPacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.uuid = in.readUUID();
        this.type = EntityType.read(in);
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.pitch = (float)(in.readByte() * 360) / 256.0f;
        this.yaw = (float)(in.readByte() * 360) / 256.0f;
        int data = in.readInt();
        this.data = this.type == EntityType.MINECART ? (ObjectData)MagicValues.key(MinecartType.class, data) : (this.type == EntityType.ITEM_FRAME || this.type == EntityType.GLOW_ITEM_FRAME ? Direction.VALUES[data] : (this.type == EntityType.FALLING_BLOCK ? new FallingBlockData(data & 0xFFFF, data >> 16) : (this.type == EntityType.POTION ? new SplashPotionData(data) : (this.type == EntityType.SPECTRAL_ARROW || this.type == EntityType.FIREBALL || this.type == EntityType.SMALL_FIREBALL || this.type == EntityType.DRAGON_FIREBALL || this.type == EntityType.WITHER_SKULL || this.type == EntityType.FISHING_BOBBER ? new ProjectileData(data) : (data == 0 ? EMPTY_DATA : new GenericObjectData(data))))));
        this.motionX = (double)in.readShort() / 8000.0;
        this.motionY = (double)in.readShort() / 8000.0;
        this.motionZ = (double)in.readShort() / 8000.0;
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeUUID(this.uuid);
        out.writeVarInt(this.type.ordinal());
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeByte((int)((byte)(this.pitch * 256.0f / 360.0f)));
        out.writeByte((int)((byte)(this.yaw * 256.0f / 360.0f)));
        int data = 0;
        if (this.data instanceof MinecartType) {
            data = MagicValues.value(Integer.class, this.data);
        } else if (this.data instanceof Direction) {
            data = ((Direction)this.data).ordinal();
        } else if (this.data instanceof FallingBlockData) {
            data = ((FallingBlockData)this.data).getId() | ((FallingBlockData)this.data).getMetadata() << 16;
        } else if (this.data instanceof SplashPotionData) {
            data = ((SplashPotionData)this.data).getPotionData();
        } else if (this.data instanceof ProjectileData) {
            data = ((ProjectileData)this.data).getOwnerId();
        } else if (this.data instanceof GenericObjectData) {
            data = ((GenericObjectData)this.data).getValue();
        }
        out.writeInt(data);
        out.writeShort((int)(this.motionX * 8000.0));
        out.writeShort((int)(this.motionY * 8000.0));
        out.writeShort((int)(this.motionZ * 8000.0));
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NonNull
    public EntityType getType() {
        return this.type;
    }

    @NonNull
    public ObjectData getData() {
        return this.data;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public double getMotionX() {
        return this.motionX;
    }

    public double getMotionY() {
        return this.motionY;
    }

    public double getMotionZ() {
        return this.motionZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAddEntityPacket)) {
            return false;
        }
        ClientboundAddEntityPacket other = (ClientboundAddEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (Double.compare(this.getMotionX(), other.getMotionX()) != 0) {
            return false;
        }
        if (Double.compare(this.getMotionY(), other.getMotionY()) != 0) {
            return false;
        }
        if (Double.compare(this.getMotionZ(), other.getMotionZ()) != 0) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        ObjectData this$data = this.getData();
        ObjectData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAddEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        long $motionX = Double.doubleToLongBits(this.getMotionX());
        result = result * 59 + (int)($motionX >>> 32 ^ $motionX);
        long $motionY = Double.doubleToLongBits(this.getMotionY());
        result = result * 59 + (int)($motionY >>> 32 ^ $motionY);
        long $motionZ = Double.doubleToLongBits(this.getMotionZ());
        result = result * 59 + (int)($motionZ >>> 32 ^ $motionZ);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        ObjectData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundAddEntityPacket(entityId=" + this.getEntityId() + ", uuid=" + this.getUuid() + ", type=" + (Object)((Object)this.getType()) + ", data=" + this.getData() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", motionX=" + this.getMotionX() + ", motionY=" + this.getMotionY() + ", motionZ=" + this.getMotionZ() + ")";
    }

    public ClientboundAddEntityPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundAddEntityPacket(entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, this.yaw, this.pitch, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withUuid(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return this.uuid == uuid ? this : new ClientboundAddEntityPacket(this.entityId, uuid, this.type, this.data, this.x, this.y, this.z, this.yaw, this.pitch, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withType(@NonNull EntityType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, type, this.data, this.x, this.y, this.z, this.yaw, this.pitch, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withData(@NonNull ObjectData data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.data == data ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, data, this.x, this.y, this.z, this.yaw, this.pitch, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withX(double x) {
        return this.x == x ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, x, this.y, this.z, this.yaw, this.pitch, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withY(double y) {
        return this.y == y ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, y, this.z, this.yaw, this.pitch, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withZ(double z) {
        return this.z == z ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, z, this.yaw, this.pitch, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, yaw, this.pitch, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, this.yaw, pitch, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withMotionX(double motionX) {
        return this.motionX == motionX ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, this.yaw, this.pitch, motionX, this.motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withMotionY(double motionY) {
        return this.motionY == motionY ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, this.yaw, this.pitch, this.motionX, motionY, this.motionZ);
    }

    public ClientboundAddEntityPacket withMotionZ(double motionZ) {
        return this.motionZ == motionZ ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, this.yaw, this.pitch, this.motionX, this.motionY, motionZ);
    }

    public ClientboundAddEntityPacket(int entityId, @NonNull UUID uuid, @NonNull EntityType type, @NonNull ObjectData data, double x, double y, double z, float yaw, float pitch, double motionX, double motionY, double motionZ) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.entityId = entityId;
        this.uuid = uuid;
        this.type = type;
        this.data = data;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }
}

